/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.authorization.servlet;

import cn.herodotus.engine.core.autoconfigure.oauth2.domain.HerodotusRequest;
import cn.herodotus.engine.core.autoconfigure.oauth2.servlet.ServletOAuth2ResourceMatcherConfigurer;
import cn.herodotus.engine.core.identity.domain.HerodotusSecurityAttribute;
import cn.herodotus.engine.oauth2.authorization.processor.SecurityAttributeStorage;
import cn.herodotus.engine.web.core.servlet.utils.HeaderUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.access.expression.WebExpressionAuthorizationManager;
import org.springframework.security.web.access.intercept.RequestAuthorizationContext;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class ServletSecurityAuthorizationManager
implements AuthorizationManager<RequestAuthorizationContext> {
    private static final Logger log = LoggerFactory.getLogger(ServletSecurityAuthorizationManager.class);
    private final SecurityAttributeStorage securityAttributeStorage;
    private final ServletOAuth2ResourceMatcherConfigurer servletOAuth2ResourceMatcherConfigurer;

    public ServletSecurityAuthorizationManager(SecurityAttributeStorage securityAttributeStorage, ServletOAuth2ResourceMatcherConfigurer servletOAuth2ResourceMatcherConfigurer) {
        this.securityAttributeStorage = securityAttributeStorage;
        this.servletOAuth2ResourceMatcherConfigurer = servletOAuth2ResourceMatcherConfigurer;
    }

    public AuthorizationDecision check(Supplier<Authentication> authentication, RequestAuthorizationContext object) {
        HttpServletRequest request = object.getRequest();
        String url = request.getRequestURI();
        String method = request.getMethod();
        if (this.servletOAuth2ResourceMatcherConfigurer.isStaticRequest(url)) {
            log.trace("[Herodotus] |- Is static resource : [{}], Passed!", (Object)url);
            return new AuthorizationDecision(true);
        }
        if (this.servletOAuth2ResourceMatcherConfigurer.isPermitAllRequest(request)) {
            log.trace("[Herodotus] |- Is white list resource : [{}], Passed!", (Object)url);
            return new AuthorizationDecision(true);
        }
        String feignInnerFlag = HeaderUtils.getHerodotusFromIn((HttpServletRequest)request);
        if (StringUtils.isNotBlank((CharSequence)feignInnerFlag)) {
            log.trace("[Herodotus] |- Is feign inner invoke : [{}], Passed!", (Object)url);
            return new AuthorizationDecision(true);
        }
        if (this.servletOAuth2ResourceMatcherConfigurer.isHasAuthenticatedRequest(request)) {
            log.trace("[Herodotus] |- Is has authenticated resource : [{}]", (Object)url);
            return new AuthorizationDecision(authentication.get().isAuthenticated());
        }
        List<HerodotusSecurityAttribute> configAttributes = this.findConfigAttribute(url, method, request);
        if (CollectionUtils.isEmpty(configAttributes)) {
            log.warn("[Herodotus] |- NO PRIVILEGES : [{}].", (Object)url);
            if (!this.servletOAuth2ResourceMatcherConfigurer.isStrictMode() && authentication.get().isAuthenticated()) {
                log.debug("[Herodotus] |- Request is authenticated: [{}].", (Object)url);
                return new AuthorizationDecision(true);
            }
            return new AuthorizationDecision(false);
        }
        for (HerodotusSecurityAttribute configAttribute : configAttributes) {
            WebExpressionAuthorizationManager webExpressionAuthorizationManager = new WebExpressionAuthorizationManager(configAttribute.getAttribute());
            AuthorizationDecision decision = webExpressionAuthorizationManager.check(authentication, object);
            if (!decision.isGranted()) continue;
            log.debug("[Herodotus] |- Request [{}] is authorized!", (Object)object.getRequest().getRequestURI());
            return decision;
        }
        return new AuthorizationDecision(false);
    }

    private List<HerodotusSecurityAttribute> findConfigAttribute(String url, String method, HttpServletRequest request) {
        log.debug("[Herodotus] |- Current Request is : [{}] - [{}]", (Object)url, (Object)method);
        List<HerodotusSecurityAttribute> configAttributes = this.securityAttributeStorage.getConfigAttribute(url, method);
        if (CollectionUtils.isNotEmpty(configAttributes)) {
            log.debug("[Herodotus] |- Get configAttributes from local storage for : [{}] - [{}]", (Object)url, (Object)method);
            return configAttributes;
        }
        LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>> compatible = this.securityAttributeStorage.getCompatible();
        if (MapUtils.isNotEmpty(compatible)) {
            for (Map.Entry<HerodotusRequest, List<HerodotusSecurityAttribute>> entry : compatible.entrySet()) {
                RequestMatcher.MatchResult matchResult = this.matches(request, entry.getKey());
                if (!matchResult.isMatch()) continue;
                log.debug("[Herodotus] |- Request match the wildcard [{}] - [{}]", (Object)entry.getKey(), entry.getValue());
                return entry.getValue();
            }
        }
        return null;
    }

    private RequestMatcher.MatchResult matches(HttpServletRequest httpServletRequest, HerodotusRequest request) {
        HttpMethod httpMethod = null;
        if (StringUtils.isNotBlank((CharSequence)request.getHttpMethod())) {
            httpMethod = HttpMethod.valueOf((String)request.getHttpMethod());
        }
        PathPatternRequestMatcher matcher = PathPatternRequestMatcher.withDefaults().matcher(httpMethod, request.getPattern());
        return matcher.matcher(httpServletRequest);
    }
}

