/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.authorization.servlet;

import cn.herodotus.engine.core.autoconfigure.oauth2.definition.SecurityGlobalExceptionHandler;
import cn.herodotus.engine.web.core.servlet.template.AbstractResponseHandler;
import cn.herodotus.engine.web.core.servlet.template.ThymeleafTemplateHandler;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;

public class HerodotusAuthenticationEntryPoint
extends AbstractResponseHandler
implements AuthenticationEntryPoint {
    private static final Logger log = LoggerFactory.getLogger(HerodotusAuthenticationEntryPoint.class);

    public HerodotusAuthenticationEntryPoint(ThymeleafTemplateHandler templateHandler) {
        super(templateHandler);
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        log.warn("[Herodotus] |- Not authenticated for request [{}],which in servlet service!", (Object)request.getRequestURI());
        this.process(request, response, () -> SecurityGlobalExceptionHandler.resolveSecurityException((Exception)exception, (String)request.getRequestURI()));
    }
}

