/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.authorization.servlet;

import cn.herodotus.engine.core.autoconfigure.oauth2.definition.SecurityGlobalExceptionHandler;
import cn.herodotus.engine.web.core.servlet.template.AbstractResponseHandler;
import cn.herodotus.engine.web.core.servlet.template.ThymeleafTemplateHandler;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandler;

public class HerodotusAccessDeniedHandler
extends AbstractResponseHandler
implements AccessDeniedHandler {
    private static final Logger log = LoggerFactory.getLogger(HerodotusAccessDeniedHandler.class);

    public HerodotusAccessDeniedHandler(ThymeleafTemplateHandler templateHandler) {
        super(templateHandler);
    }

    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException exception) throws IOException, ServletException {
        log.warn("[Herodotus] |- Access Denied for request [{}],which in reactive service!", (Object)request.getRequestURI());
        this.process(request, response, () -> SecurityGlobalExceptionHandler.resolveSecurityException((Exception)exception, (String)request.getRequestURI()));
    }
}

