/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.authorization.processor;

import cn.herodotus.engine.cache.jetcache.utils.JetCacheUtils;
import cn.herodotus.engine.core.autoconfigure.oauth2.domain.HerodotusRequest;
import cn.herodotus.engine.core.identity.domain.HerodotusSecurityAttribute;
import cn.herodotus.engine.oauth2.authorization.matcher.HerodotusPathPatternRequestMatcher;
import com.alicp.jetcache.Cache;
import com.alicp.jetcache.anno.CacheType;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityAttributeStorage {
    private static final Logger log = LoggerFactory.getLogger(SecurityAttributeStorage.class);
    private static final String KEY_COMPATIBLE = "COMPATIBLE";
    private final Cache<String, LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>>> compatible = JetCacheUtils.create((String)"cache:security:metadata:compatible:", (CacheType)CacheType.BOTH, null, (Boolean)true, (Boolean)true);
    private final Cache<HerodotusRequest, List<HerodotusSecurityAttribute>> indexable = JetCacheUtils.create((String)"cache:security:metadata:indexable:", (CacheType)CacheType.BOTH, null, (Boolean)true, (Boolean)true);

    private LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>> readFromCompatible() {
        LinkedHashMap compatible = (LinkedHashMap)this.compatible.get((Object)KEY_COMPATIBLE);
        if (MapUtils.isNotEmpty((Map)compatible)) {
            return compatible;
        }
        return new LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>>();
    }

    private void writeToCompatible(LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>> compatible) {
        this.compatible.put((Object)KEY_COMPATIBLE, compatible);
    }

    private List<HerodotusSecurityAttribute> readFromIndexable(HerodotusRequest herodotusRequest) {
        return (List)this.indexable.get((Object)herodotusRequest);
    }

    private void writeToIndexable(HerodotusRequest herodotusRequest, List<HerodotusSecurityAttribute> configAttributes) {
        this.indexable.put((Object)herodotusRequest, configAttributes);
    }

    public List<HerodotusSecurityAttribute> getConfigAttribute(String url, String method) {
        HerodotusRequest herodotusRequest = new HerodotusRequest(url, method);
        return this.readFromIndexable(herodotusRequest);
    }

    public LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>> getCompatible() {
        return this.readFromCompatible();
    }

    private void appendToCompatible(HerodotusRequest herodotusRequest, List<HerodotusSecurityAttribute> configAttributes) {
        LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>> compatible = this.getCompatible();
        compatible.put(herodotusRequest, configAttributes);
        log.trace("[Herodotus] |- Append [{}] to Compatible cache, current size is [{}]", (Object)herodotusRequest, (Object)compatible.size());
        this.writeToCompatible(compatible);
    }

    private void appendToCompatible(LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>> configAttributes) {
        configAttributes.forEach(this::appendToCompatible);
    }

    private void appendToIndexable(HerodotusRequest herodotusRequest, List<HerodotusSecurityAttribute> configAttributes) {
        this.writeToIndexable(herodotusRequest, configAttributes);
    }

    private void appendToIndexable(LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>> configAttributes) {
        configAttributes.forEach(this::appendToIndexable);
    }

    public void addToStorage(LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>> configAttributes, boolean isIndexable) {
        if (MapUtils.isNotEmpty(configAttributes)) {
            if (isIndexable) {
                this.appendToIndexable(configAttributes);
            } else {
                this.appendToCompatible(configAttributes);
            }
        }
    }

    public void addToStorage(LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>> matchers, LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>> configAttributes, boolean isIndexable) {
        LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>> result = new LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>>();
        if (MapUtils.isNotEmpty(matchers) && MapUtils.isNotEmpty(configAttributes)) {
            result = this.checkConflict(matchers, configAttributes);
        }
        this.addToStorage(result, isIndexable);
    }

    private LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>> checkConflict(LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>> matchers, LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>> configAttributes) {
        LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>> result = new LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>>(configAttributes);
        for (HerodotusRequest matcher : matchers.keySet()) {
            for (HerodotusRequest item : configAttributes.keySet()) {
                HerodotusPathPatternRequestMatcher requestMatcher;
                if (matcher.equals((Object)item) || !(requestMatcher = HerodotusPathPatternRequestMatcher.withDefaults().matcher(matcher)).matches(item)) continue;
                result.remove(item);
                log.trace("[Herodotus] |- Pattern [{}] is conflict with [{}], so remove it.", (Object)item.getPattern(), (Object)matcher.getPattern());
            }
        }
        return result;
    }
}

