/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.authorization.processor;

import cn.herodotus.engine.core.autoconfigure.oauth2.domain.HerodotusRequest;
import cn.herodotus.engine.core.autoconfigure.oauth2.servlet.ServletOAuth2ResourceMatcherConfigurer;
import cn.herodotus.engine.core.foundation.enums.UrlCategory;
import cn.herodotus.engine.core.identity.domain.AttributeTransmitter;
import cn.herodotus.engine.core.identity.domain.HerodotusSecurityAttribute;
import cn.herodotus.engine.oauth2.authorization.processor.SecurityAttributeStorage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SecurityAttributeAnalyzer {
    private static final Logger log = LoggerFactory.getLogger(SecurityAttributeAnalyzer.class);
    private final SecurityAttributeStorage securityAttributeStorage;
    private final ServletOAuth2ResourceMatcherConfigurer servletOAuth2ResourceMatcherConfigurer;

    public SecurityAttributeAnalyzer(SecurityAttributeStorage securityAttributeStorage, ServletOAuth2ResourceMatcherConfigurer servletOAuth2ResourceMatcherConfigurer) {
        this.securityAttributeStorage = securityAttributeStorage;
        this.servletOAuth2ResourceMatcherConfigurer = servletOAuth2ResourceMatcherConfigurer;
    }

    private String hasAuthority(String authority) {
        return "hasAuthority('" + authority + "')";
    }

    private void appendToGroup(Map<UrlCategory, LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>>> container, UrlCategory urlCategory, LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>> resources) {
        LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>> value = new LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>>();
        if (container.containsKey(urlCategory)) {
            value = container.get(urlCategory);
        }
        value.putAll(resources);
        container.put(urlCategory, value);
    }

    private Map<UrlCategory, LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>>> groupSecurityMatchers(Map<HerodotusRequest, List<HerodotusSecurityAttribute>> securityMatchers) {
        LinkedHashMap<UrlCategory, LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>>> group = new LinkedHashMap<UrlCategory, LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>>>();
        securityMatchers.forEach((key, value) -> {
            LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>> resources = new LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>>();
            resources.put((HerodotusRequest)key, (List<HerodotusSecurityAttribute>)value);
            this.appendToGroup(group, UrlCategory.getCategory((String)key.getPattern()), resources);
        });
        log.debug("[Herodotus] |- Grouping security matcher by category.");
        return group;
    }

    private List<HerodotusSecurityAttribute> analysis(AttributeTransmitter attributeTransmitter) {
        ArrayList<HerodotusSecurityAttribute> attributes = new ArrayList<HerodotusSecurityAttribute>();
        if (StringUtils.isNotBlank((CharSequence)attributeTransmitter.getPermissions())) {
            String[] permissions = org.springframework.util.StringUtils.commaDelimitedListToStringArray((String)attributeTransmitter.getPermissions());
            Arrays.stream(permissions).forEach(item -> attributes.add(new HerodotusSecurityAttribute(this.hasAuthority((String)item))));
        }
        if (StringUtils.isNotBlank((CharSequence)attributeTransmitter.getWebExpression())) {
            attributes.add(new HerodotusSecurityAttribute(attributeTransmitter.getWebExpression()));
        }
        return attributes;
    }

    private LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>> convert(String url, String methods, List<HerodotusSecurityAttribute> configAttributes) {
        LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>> result = new LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>>();
        if (StringUtils.isBlank((CharSequence)methods)) {
            result.put(new HerodotusRequest(url), configAttributes);
        } else if (Strings.CS.contains((CharSequence)methods, (CharSequence)",")) {
            String[] multiMethod;
            for (String method : multiMethod = StringUtils.split((String)methods, (String)",")) {
                result.put(new HerodotusRequest(url, method), configAttributes);
            }
        } else {
            result.put(new HerodotusRequest(url, methods), configAttributes);
        }
        return result;
    }

    private Map<UrlCategory, LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>>> groupingSecurityMetadata(List<AttributeTransmitter> attributeTransmitters) {
        LinkedHashMap<UrlCategory, LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>>> group = new LinkedHashMap<UrlCategory, LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>>>();
        attributeTransmitters.forEach(attributeTransmitter -> {
            LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>> resources = this.convert(attributeTransmitter.getUrl(), attributeTransmitter.getRequestMethod(), this.analysis((AttributeTransmitter)attributeTransmitter));
            this.appendToGroup(group, UrlCategory.getCategory((String)attributeTransmitter.getUrl()), resources);
        });
        log.debug("[Herodotus] |- Grouping security metadata by category.");
        return group;
    }

    public void processRequestMatchers() {
        log.debug("[Herodotus] |- [R3] Process local configured security metadata.");
        Map requestMatchers = this.servletOAuth2ResourceMatcherConfigurer.getPermitAllAttributes();
        if (MapUtils.isNotEmpty((Map)requestMatchers)) {
            Map<UrlCategory, LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>>> grouping = this.groupSecurityMatchers(requestMatchers);
            LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>> wildcards = grouping.get(UrlCategory.WILDCARD);
            this.securityAttributeStorage.addToStorage(wildcards, false);
            LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>> fullPaths = grouping.get(UrlCategory.FULL_PATH);
            this.securityAttributeStorage.addToStorage(fullPaths, true);
        }
    }

    public void processAttributeTransmitters(List<AttributeTransmitter> attributeTransmitters) {
        LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>> compatibles = this.securityAttributeStorage.getCompatible();
        LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>> matchers = new LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>>(compatibles);
        Map<UrlCategory, LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>>> grouping = this.groupingSecurityMetadata(attributeTransmitters);
        LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>> wildcards = grouping.get(UrlCategory.WILDCARD);
        if (MapUtils.isNotEmpty(wildcards)) {
            matchers.putAll(wildcards);
            this.securityAttributeStorage.addToStorage(wildcards, false);
        }
        LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>> placeholders = grouping.get(UrlCategory.PLACEHOLDER);
        log.debug("[Herodotus] |- Store placeholder type security attributes.");
        this.securityAttributeStorage.addToStorage(matchers, placeholders, false);
        LinkedHashMap<HerodotusRequest, List<HerodotusSecurityAttribute>> fullPaths = grouping.get(UrlCategory.FULL_PATH);
        log.debug("[Herodotus] |- Store full path type security attributes.");
        this.securityAttributeStorage.addToStorage(matchers, fullPaths, true);
        log.debug("[Herodotus] |- [R7] Security attributes process has FINISHED!");
    }
}

