/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.authorization.matcher;

import cn.herodotus.engine.core.autoconfigure.oauth2.domain.HerodotusRequest;
import cn.herodotus.engine.oauth2.authorization.matcher.HerodotusAnyRequestMatcher;
import cn.herodotus.engine.oauth2.authorization.matcher.HerodotusRequestMatcher;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.PathContainer;
import org.springframework.http.server.RequestPath;
import org.springframework.lang.Nullable;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.web.util.ServletRequestPathUtils;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

public class HerodotusPathPatternRequestMatcher
implements HerodotusRequestMatcher {
    private final PathPattern pattern;
    private final HerodotusRequestMatcher method;

    private HerodotusPathPatternRequestMatcher(PathPattern pattern, HerodotusRequestMatcher method) {
        this.pattern = pattern;
        this.method = method;
    }

    public static Builder withDefaults() {
        return new Builder();
    }

    public static Builder withPathPatternParser(PathPatternParser parser) {
        Assert.notNull((Object)parser, (String)"pathPatternParser cannot be null");
        return new Builder(parser);
    }

    public boolean matches(HttpServletRequest request) {
        return this.matcher(request).isMatch();
    }

    public RequestMatcher.MatchResult matcher(HttpServletRequest request) {
        if (!this.method.matches(request)) {
            return RequestMatcher.MatchResult.notMatch();
        }
        PathContainer path = this.getPathContainer(request);
        PathPattern.PathMatchInfo info = this.pattern.matchAndExtract(path);
        return info != null ? RequestMatcher.MatchResult.match((Map)info.getUriVariables()) : RequestMatcher.MatchResult.notMatch();
    }

    @Override
    public boolean matches(HerodotusRequest request) {
        return this.matcher(request).isMatch();
    }

    @Override
    public RequestMatcher.MatchResult matcher(HerodotusRequest request) {
        if (!this.method.matches(request)) {
            return RequestMatcher.MatchResult.notMatch();
        }
        PathContainer path = this.getPathContainer(request.getPattern());
        PathPattern.PathMatchInfo info = this.pattern.matchAndExtract(path);
        return info != null ? RequestMatcher.MatchResult.match((Map)info.getUriVariables()) : RequestMatcher.MatchResult.notMatch();
    }

    private PathContainer getPathContainer(HttpServletRequest request) {
        RequestPath path;
        if (ServletRequestPathUtils.hasParsedRequestPath((ServletRequest)request)) {
            path = ServletRequestPathUtils.getParsedRequestPath((ServletRequest)request);
        } else {
            path = ServletRequestPathUtils.parseAndCache((HttpServletRequest)request);
            ServletRequestPathUtils.clearParsedRequestPath((ServletRequest)request);
        }
        PathContainer contextPath = path.contextPath();
        return path.subPath(contextPath.elements().size());
    }

    private PathContainer getPathContainer(String uri) {
        return RequestPath.parse((String)uri, null);
    }

    public boolean equals(Object o) {
        if (!(o instanceof HerodotusPathPatternRequestMatcher)) {
            return false;
        }
        HerodotusPathPatternRequestMatcher that = (HerodotusPathPatternRequestMatcher)o;
        return Objects.equals(this.pattern, that.pattern) && Objects.equals(this.method, that.method);
    }

    public int hashCode() {
        return Objects.hash(this.pattern, this.method);
    }

    public String toString() {
        StringBuilder request = new StringBuilder();
        HerodotusRequestMatcher herodotusRequestMatcher = this.method;
        if (herodotusRequestMatcher instanceof HttpMethodRequestMatcher) {
            HttpMethodRequestMatcher m = (HttpMethodRequestMatcher)herodotusRequestMatcher;
            request.append(m.method.name()).append(' ');
        }
        return "PathPattern [" + String.valueOf(request) + String.valueOf(this.pattern) + "]";
    }

    public static final class Builder {
        private final PathPatternParser parser;
        private final String basePath;

        Builder() {
            this(PathPatternParser.defaultInstance);
        }

        Builder(PathPatternParser parser) {
            this(parser, "");
        }

        Builder(PathPatternParser parser, String basePath) {
            this.parser = parser;
            this.basePath = basePath;
        }

        public Builder basePath(String basePath) {
            Assert.notNull((Object)basePath, (String)"basePath cannot be null");
            Assert.isTrue((boolean)basePath.startsWith("/"), (String)"basePath must start with '/'");
            Assert.isTrue((!basePath.endsWith("/") ? 1 : 0) != 0, (String)"basePath must not end with a slash");
            Assert.isTrue((!basePath.contains("*") ? 1 : 0) != 0, (String)"basePath must not contain a star");
            return new Builder(this.parser, basePath);
        }

        public HerodotusPathPatternRequestMatcher matcher(String path) {
            return this.matcher(null, path);
        }

        public HerodotusPathPatternRequestMatcher matcher(@Nullable HttpMethod method, String path) {
            Assert.notNull((Object)path, (String)"pattern cannot be null");
            Assert.isTrue((boolean)path.startsWith("/"), (String)"pattern must start with a /");
            PathPattern pathPattern = this.parser.parse(this.basePath + path);
            return new HerodotusPathPatternRequestMatcher(pathPattern, method != null ? new HttpMethodRequestMatcher(method) : HerodotusAnyRequestMatcher.INSTANCE);
        }

        public HerodotusPathPatternRequestMatcher matcher(HerodotusRequest request) {
            HttpMethod method = null;
            if (StringUtils.isNotBlank((CharSequence)request.getHttpMethod())) {
                method = HttpMethod.valueOf((String)request.getHttpMethod());
            }
            return this.matcher(method, request.getPattern());
        }
    }

    private static final class HttpMethodRequestMatcher
    implements HerodotusRequestMatcher {
        private final HttpMethod method;

        HttpMethodRequestMatcher(HttpMethod method) {
            this.method = method;
        }

        public boolean matches(HttpServletRequest request) {
            return this.method.name().equals(request.getMethod());
        }

        @Override
        public boolean matches(HerodotusRequest request) {
            return Strings.CI.equals(this.method.name(), request.getHttpMethod());
        }

        public String toString() {
            return "HttpMethod [" + String.valueOf(this.method) + "]";
        }
    }
}

