/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.core.utils;

import cn.herodotus.engine.assistant.core.json.jackson2.utils.Jackson2Utils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class WebUtils
extends org.springframework.web.util.WebUtils {
    private static final Logger log = LoggerFactory.getLogger(WebUtils.class);

    public static RequestMatcher[] toRequestMatchers(List<String> paths) {
        if (CollectionUtils.isNotEmpty(paths)) {
            List<AntPathRequestMatcher> matchers = paths.stream().map(item -> new AntPathRequestMatcher(item, null, false)).toList();
            RequestMatcher[] result = new RequestMatcher[matchers.size()];
            return matchers.toArray(result);
        }
        return new RequestMatcher[0];
    }

    public static boolean isRequestMatched(RequestMatcher[] matchers, HttpServletRequest request) {
        for (RequestMatcher matcher : matchers) {
            if (!matcher.matches(request)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRequestMatched(List<String> paths, HttpServletRequest request) {
        RequestMatcher[] matchers = WebUtils.toRequestMatchers(paths);
        return WebUtils.isRequestMatched(matchers, request);
    }

    public static void renderJson(HttpServletResponse response, Object object) {
        WebUtils.renderJson(response, Jackson2Utils.toJson((Object)object), MediaType.APPLICATION_JSON.toString());
    }

    public static void renderJson(HttpServletResponse response, String string, String type) {
        try {
            response.setContentType(type);
            response.setCharacterEncoding(StandardCharsets.UTF_8.toString());
            response.getWriter().print(string);
            response.getWriter().flush();
            response.getWriter().close();
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Render response to Json error!");
        }
    }
}

