/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.core.jackson2;

import cn.herodotus.engine.oauth2.core.definition.domain.HerodotusGrantedAuthority;
import cn.herodotus.engine.oauth2.core.definition.domain.HerodotusUser;
import cn.herodotus.stirrup.kernel.engine.json.jackson2.utils.JsonNodeUtils;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Set;

public class HerodotusUserDeserializer
extends JsonDeserializer<HerodotusUser> {
    private static final TypeReference<Set<HerodotusGrantedAuthority>> HERODOTUS_GRANTED_AUTHORITY_SET = new TypeReference<Set<HerodotusGrantedAuthority>>(){};
    private static final TypeReference<Set<String>> HERODOTUS_ROLE_SET = new TypeReference<Set<String>>(){};

    public HerodotusUser deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        JsonNode jsonNode = (JsonNode)mapper.readTree(jp);
        Set authorities = (Set)mapper.convertValue((Object)jsonNode.get("authorities"), HERODOTUS_GRANTED_AUTHORITY_SET);
        Set roles = (Set)mapper.convertValue((Object)jsonNode.get("roles"), HERODOTUS_ROLE_SET);
        JsonNode passwordNode = JsonNodeUtils.readJsonNode((JsonNode)jsonNode, (String)"password");
        String userId = JsonNodeUtils.findStringValue((JsonNode)jsonNode, (String)"userId");
        String username = JsonNodeUtils.findStringValue((JsonNode)jsonNode, (String)"username");
        String password = passwordNode.asText("");
        boolean enabled = JsonNodeUtils.findBooleanValue((JsonNode)jsonNode, (String)"enabled");
        boolean accountNonExpired = JsonNodeUtils.findBooleanValue((JsonNode)jsonNode, (String)"accountNonExpired");
        boolean credentialsNonExpired = JsonNodeUtils.findBooleanValue((JsonNode)jsonNode, (String)"credentialsNonExpired");
        boolean accountNonLocked = JsonNodeUtils.findBooleanValue((JsonNode)jsonNode, (String)"accountNonLocked");
        String employeeId = JsonNodeUtils.findStringValue((JsonNode)jsonNode, (String)"employeeId");
        String avatar = JsonNodeUtils.findStringValue((JsonNode)jsonNode, (String)"avatar");
        HerodotusUser result = new HerodotusUser(userId, username, password, enabled, accountNonExpired, credentialsNonExpired, accountNonLocked, authorities, roles, employeeId, avatar);
        if (passwordNode.asText(null) == null) {
            result.eraseCredentials();
        }
        return result;
    }
}

