/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.core.utils;

import cn.herodotus.engine.assistant.core.domain.PrincipalDetails;
import cn.herodotus.engine.oauth2.core.definition.domain.HerodotusUser;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.jwt.Jwt;

public class PrincipalUtils {
    public static PrincipalDetails toPrincipalDetails(HerodotusUser herodotusUser) {
        PrincipalDetails details = new PrincipalDetails();
        details.setOpenId(herodotusUser.getUserId());
        details.setUsername(herodotusUser.getUsername());
        details.setRoles(herodotusUser.getRoles());
        details.setAvatar(herodotusUser.getAvatar());
        details.setEmployeeId(herodotusUser.getEmployeeId());
        return details;
    }

    public static PrincipalDetails toPrincipalDetails(OAuth2AuthenticatedPrincipal authenticatedPrincipal) {
        PrincipalDetails details = new PrincipalDetails();
        details.setOpenId((String)authenticatedPrincipal.getAttribute("openid"));
        details.setUsername(authenticatedPrincipal.getName());
        List roles = (List)authenticatedPrincipal.getAttribute("roles");
        if (CollectionUtils.isNotEmpty((Collection)roles)) {
            details.setRoles(new HashSet(roles));
        }
        details.setAvatar((String)authenticatedPrincipal.getAttribute("avatar"));
        details.setEmployeeId((String)authenticatedPrincipal.getAttribute("employeeId"));
        return details;
    }

    public static PrincipalDetails toPrincipalDetails(Jwt jwt) {
        PrincipalDetails details = new PrincipalDetails();
        details.setOpenId(jwt.getClaimAsString("openid"));
        details.setUsername(jwt.getClaimAsString("sub"));
        details.setRoles((Set)jwt.getClaim("roles"));
        details.setAvatar(jwt.getClaimAsString("avatar"));
        details.setEmployeeId(jwt.getClaimAsString("employeeId"));
        return details;
    }
}

