/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.core.exception;

import cn.herodotus.engine.assistant.core.definition.constants.ErrorCodes;
import cn.herodotus.engine.assistant.core.domain.Feedback;
import cn.herodotus.engine.assistant.core.domain.Result;
import cn.herodotus.engine.assistant.core.exception.GlobalExceptionHandler;
import cn.herodotus.engine.assistant.core.exception.PlatformException;
import cn.herodotus.engine.oauth2.core.exception.PlatformAuthenticationException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;

@RestControllerAdvice
public class SecurityGlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(SecurityGlobalExceptionHandler.class);
    private static final Map<String, Feedback> EXCEPTION_DICTIONARY = new HashMap<String, Feedback>();

    @ExceptionHandler(value={HttpClientErrorException.class, HttpServerErrorException.class})
    public static Result<String> restTemplateException(Exception ex, HttpServletRequest request, HttpServletResponse response) {
        Result<String> result = SecurityGlobalExceptionHandler.resolveException(ex, request.getRequestURI());
        response.setStatus(result.getStatus());
        return result;
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public static Result<String> validationMethodArgumentException(MethodArgumentNotValidException ex, HttpServletRequest request, HttpServletResponse response) {
        return SecurityGlobalExceptionHandler.validationBindException((BindException)ex, request, response);
    }

    @ExceptionHandler(value={BindException.class})
    public static Result<String> validationBindException(BindException ex, HttpServletRequest request, HttpServletResponse response) {
        Result<String> result = SecurityGlobalExceptionHandler.resolveException((Exception)ex, request.getRequestURI());
        BindingResult bindingResult = ex.getBindingResult();
        FieldError fieldError = bindingResult.getFieldError();
        if (ObjectUtils.isNotEmpty((Object)fieldError)) {
            result.validation(fieldError.getDefaultMessage(), fieldError.getCode(), fieldError.getField());
        }
        response.setStatus(result.getStatus());
        return result;
    }

    @ExceptionHandler(value={AuthenticationException.class, PlatformAuthenticationException.class})
    public static Result<String> authenticationException(Exception ex, HttpServletRequest request, HttpServletResponse response) {
        Result<String> result = SecurityGlobalExceptionHandler.resolveSecurityException(ex, request.getRequestURI());
        response.setStatus(result.getStatus());
        return result;
    }

    @ExceptionHandler(value={OAuth2AuthenticationException.class})
    public static Result<String> oAuth2AuthenticationException(Exception ex, HttpServletRequest request, HttpServletResponse response) {
        Result<String> result = SecurityGlobalExceptionHandler.resolveSecurityException(ex, request.getRequestURI());
        response.setStatus(result.getStatus());
        return result;
    }

    @ExceptionHandler(value={Exception.class, PlatformException.class})
    public static Result<String> exception(Exception ex, HttpServletRequest request, HttpServletResponse response) {
        Result<String> result = SecurityGlobalExceptionHandler.resolveException(ex, request.getRequestURI());
        response.setStatus(result.getStatus());
        return result;
    }

    public static Result<String> resolveException(Exception ex, String path) {
        return GlobalExceptionHandler.resolveException((Exception)ex, (String)path);
    }

    public static Result<String> resolveSecurityException(Exception exception, String path) {
        Exception reason = new Exception();
        if (exception instanceof OAuth2AuthenticationException) {
            OAuth2AuthenticationException oAuth2AuthenticationException = (OAuth2AuthenticationException)exception;
            OAuth2Error oAuth2Error = oAuth2AuthenticationException.getError();
            if (EXCEPTION_DICTIONARY.containsKey(oAuth2Error.getErrorCode())) {
                Feedback feedback = EXCEPTION_DICTIONARY.get(oAuth2Error.getErrorCode());
                Result result = Result.failure((Feedback)feedback);
                result.path(oAuth2Error.getUri());
                result.stackTrace(exception.getStackTrace());
                result.detail(exception.getMessage());
                return result;
            }
        } else if (exception instanceof InsufficientAuthenticationException) {
            Throwable throwable = exception.getCause();
            reason = ObjectUtils.isNotEmpty((Object)throwable) ? new Exception(throwable) : exception;
            log.debug("[Herodotus] |- InsufficientAuthenticationException cause content is [{}]", (Object)reason.getClass().getSimpleName());
        } else {
            String exceptionName = exception.getClass().getSimpleName();
            if (StringUtils.isNotEmpty((CharSequence)exceptionName) && EXCEPTION_DICTIONARY.containsKey(exceptionName)) {
                Feedback feedback = EXCEPTION_DICTIONARY.get(exceptionName);
                return Result.failure((Feedback)feedback);
            }
            reason = exception;
        }
        return SecurityGlobalExceptionHandler.resolveException(reason, path);
    }

    static {
        EXCEPTION_DICTIONARY.put("access_denied", (Feedback)ErrorCodes.ACCESS_DENIED);
        EXCEPTION_DICTIONARY.put("insufficient_scope", (Feedback)ErrorCodes.INSUFFICIENT_SCOPE);
        EXCEPTION_DICTIONARY.put("invalid_client", (Feedback)ErrorCodes.INVALID_CLIENT);
        EXCEPTION_DICTIONARY.put("invalid_grant", (Feedback)ErrorCodes.INVALID_GRANT);
        EXCEPTION_DICTIONARY.put("invalid_redirect_uri", (Feedback)ErrorCodes.INVALID_REDIRECT_URI);
        EXCEPTION_DICTIONARY.put("invalid_request", (Feedback)ErrorCodes.INVALID_REQUEST);
        EXCEPTION_DICTIONARY.put("invalid_scope", (Feedback)ErrorCodes.INVALID_SCOPE);
        EXCEPTION_DICTIONARY.put("invalid_token", (Feedback)ErrorCodes.INVALID_TOKEN);
        EXCEPTION_DICTIONARY.put("server_error", (Feedback)ErrorCodes.SERVER_ERROR);
        EXCEPTION_DICTIONARY.put("temporarily_unavailable", (Feedback)ErrorCodes.TEMPORARILY_UNAVAILABLE);
        EXCEPTION_DICTIONARY.put("unauthorized_client", (Feedback)ErrorCodes.UNAUTHORIZED_CLIENT);
        EXCEPTION_DICTIONARY.put("unsupported_grant_type", (Feedback)ErrorCodes.UNSUPPORTED_GRANT_TYPE);
        EXCEPTION_DICTIONARY.put("unsupported_response_type", (Feedback)ErrorCodes.UNSUPPORTED_RESPONSE_TYPE);
        EXCEPTION_DICTIONARY.put("unsupported_token_type", (Feedback)ErrorCodes.UNSUPPORTED_TOKEN_TYPE);
        EXCEPTION_DICTIONARY.put("AccountExpiredException", (Feedback)ErrorCodes.ACCOUNT_EXPIRED);
        EXCEPTION_DICTIONARY.put("BadCredentialsException", (Feedback)ErrorCodes.BAD_CREDENTIALS);
        EXCEPTION_DICTIONARY.put("CredentialsExpiredException", (Feedback)ErrorCodes.CREDENTIALS_EXPIRED);
        EXCEPTION_DICTIONARY.put("DisabledException", (Feedback)ErrorCodes.ACCOUNT_DISABLED);
        EXCEPTION_DICTIONARY.put("LockedException", (Feedback)ErrorCodes.ACCOUNT_LOCKED);
        EXCEPTION_DICTIONARY.put("AccountEndpointLimitedException", (Feedback)ErrorCodes.ACCOUNT_ENDPOINT_LIMITED);
        EXCEPTION_DICTIONARY.put("UsernameNotFoundException", (Feedback)ErrorCodes.USERNAME_NOT_FOUND);
        EXCEPTION_DICTIONARY.put("SessionExpiredException", (Feedback)ErrorCodes.SESSION_EXPIRED);
    }
}

