/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.core.enums;

import cn.herodotus.engine.assistant.core.definition.enums.BaseUiEnum;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableMap;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Schema(name="\u7b7e\u540d\u7b97\u6cd5")
@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public enum SignatureJwsAlgorithm implements BaseUiEnum<Integer>
{
    RS256(0, "\u7b7e\u540d\u7b97\u6cd5 RS256"),
    RS384(1, "\u7b7e\u540d\u7b97\u6cd5RS384"),
    RS512(2, "\u7b7e\u540d\u7b97\u6cd5 RS512"),
    ES256(3, "\u7b7e\u540d\u7b97\u6cd5 ES256"),
    ES384(4, "\u7b7e\u540d\u7b97\u6cd5 ES384"),
    ES512(5, "\u7b7e\u540d\u7b97\u6cd5 ES512"),
    PS256(6, "\u7b7e\u540d\u7b97\u6cd5 PS256"),
    PS384(7, "\u7b7e\u540d\u7b97\u6cd5 PS384"),
    PS512(8, "\u7b7e\u540d\u7b97\u6cd5 PS512");

    private static final Map<Integer, SignatureJwsAlgorithm> INDEX_MAP;
    private static final List<Map<String, Object>> JSON_STRUCTURE;
    @Schema(title="\u679a\u4e3e\u503c")
    private final Integer value;
    @Schema(name="\u6587\u5b57")
    private final String description;

    private SignatureJwsAlgorithm(Integer value, String description) {
        this.value = value;
        this.description = description;
    }

    public static SignatureJwsAlgorithm get(Integer index) {
        return INDEX_MAP.get(index);
    }

    public static List<Map<String, Object>> getPreprocessedJsonStructure() {
        return JSON_STRUCTURE;
    }

    @JsonValue
    public Integer getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    static {
        INDEX_MAP = new HashMap<Integer, SignatureJwsAlgorithm>();
        JSON_STRUCTURE = new ArrayList<Map<String, Object>>();
        for (SignatureJwsAlgorithm signatureJwsAlgorithm : SignatureJwsAlgorithm.values()) {
            INDEX_MAP.put(signatureJwsAlgorithm.getValue(), signatureJwsAlgorithm);
            JSON_STRUCTURE.add(signatureJwsAlgorithm.getValue(), (Map<String, Object>)ImmutableMap.builder().put((Object)"value", (Object)signatureJwsAlgorithm.getValue()).put((Object)"key", (Object)signatureJwsAlgorithm.name()).put((Object)"text", (Object)signatureJwsAlgorithm.getDescription()).put((Object)"index", (Object)signatureJwsAlgorithm.getValue()).build());
        }
    }
}

