/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.core.definition.details;

import cn.herodotus.engine.oauth2.core.utils.SymmetricUtils;
import cn.herodotus.engine.rest.core.utils.WebUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.web.authentication.WebAuthenticationDetails;

public class FormLoginWebAuthenticationDetails
extends WebAuthenticationDetails {
    private final Boolean closed;
    private final String parameterName;
    private final String category;
    private String code = null;
    private String identity = null;

    public FormLoginWebAuthenticationDetails(String remoteAddress, String sessionId, Boolean closed, String parameterName, String category, String code, String identity) {
        super(remoteAddress, sessionId);
        this.closed = closed;
        this.parameterName = parameterName;
        this.category = category;
        this.code = code;
        this.identity = identity;
    }

    public FormLoginWebAuthenticationDetails(HttpServletRequest request, boolean closed, String parameterName, String category) {
        super(request);
        this.closed = closed;
        this.parameterName = parameterName;
        this.category = category;
        this.init(request);
    }

    private void init(HttpServletRequest request) {
        String encryptedCode = request.getParameter(this.parameterName);
        String key = request.getParameter("symmetric");
        HttpSession session = WebUtils.getSession((HttpServletRequest)request);
        this.identity = session.getId();
        if (StringUtils.isNotBlank((CharSequence)key) && StringUtils.isNotBlank((CharSequence)encryptedCode)) {
            byte[] byteKey = SymmetricUtils.getDecryptedSymmetricKey(key);
            this.code = SymmetricUtils.decrypt(encryptedCode, byteKey);
        }
    }

    public Boolean getClosed() {
        return this.closed;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public String getCategory() {
        return this.category;
    }

    public String getCode() {
        return this.code;
    }

    public String getIdentity() {
        return this.identity;
    }
}

