/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.core.configurer;

import cn.herodotus.engine.assistant.core.utils.ListUtils;
import cn.herodotus.engine.oauth2.core.properties.SecurityProperties;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class SecurityMatcherConfigurer {
    private static final List<String> DEFAULT_IGNORED_STATIC_RESOURCES = Lists.newArrayList((Object[])new String[]{"/error/**", "/plugins/**", "/authorization/**", "/static/**", "/webjars/**", "/swagger-ui.html", "/swagger-ui/**", "/swagger-resources/**", "/v3/api-docs", "/v3/api-docs/**", "/openapi.json", "/favicon.ico"});
    private static final List<String> DEFAULT_PERMIT_ALL_RESOURCES = Lists.newArrayList((Object[])new String[]{"/open/**", "/stomp/ws", "/oauth2/sign-out", "/login*"});
    private static final List<String> DEFAULT_HAS_AUTHENTICATED_RESOURCES = Lists.newArrayList((Object[])new String[]{"/engine-rest/**"});
    private List<String> staticResources;
    private List<String> permitAllResources;
    private List<String> hasAuthenticatedResources;
    private final SecurityProperties securityProperties;

    public SecurityMatcherConfigurer(SecurityProperties securityProperties) {
        this.securityProperties = securityProperties;
        this.staticResources = new ArrayList<String>();
        this.permitAllResources = new ArrayList<String>();
        this.hasAuthenticatedResources = new ArrayList<String>();
    }

    public List<String> getStaticResourceList() {
        if (CollectionUtils.isEmpty(this.staticResources)) {
            this.staticResources = ListUtils.merge(this.securityProperties.getMatcher().getStaticResources(), DEFAULT_IGNORED_STATIC_RESOURCES);
        }
        return this.staticResources;
    }

    public List<String> getPermitAllList() {
        if (CollectionUtils.isEmpty(this.permitAllResources)) {
            this.permitAllResources = ListUtils.merge(this.securityProperties.getMatcher().getPermitAll(), DEFAULT_PERMIT_ALL_RESOURCES);
        }
        return this.permitAllResources;
    }

    public List<String> getHasAuthenticatedList() {
        if (CollectionUtils.isEmpty(this.hasAuthenticatedResources)) {
            this.hasAuthenticatedResources = ListUtils.merge(this.securityProperties.getMatcher().getHasAuthenticated(), DEFAULT_HAS_AUTHENTICATED_RESOURCES);
        }
        return this.hasAuthenticatedResources;
    }

    public String[] getStaticResourceArray() {
        return ListUtils.toArray(this.getStaticResourceList());
    }

    public String[] getPermitAllArray() {
        return ListUtils.toArray(this.getPermitAllList());
    }
}

