/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.core.utils;

import cn.herodotus.engine.oauth2.core.definition.domain.HerodotusUser;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.server.resource.introspection.OAuth2IntrospectionAuthenticatedPrincipal;

public class SecurityUtils {
    private static final Logger log = LoggerFactory.getLogger(SecurityUtils.class);
    private static final PasswordEncoder passwordEncoder = PasswordEncoderFactories.createDelegatingPasswordEncoder();
    public static final String PREFIX_ROLE = "ROLE_";
    public static final String PREFIX_SCOPE = "SCOPE_";

    public static String encrypt(String password) {
        return passwordEncoder.encode((CharSequence)password);
    }

    public static boolean matches(String rawPassword, String encodedPassword) {
        return passwordEncoder.matches((CharSequence)rawPassword, encodedPassword);
    }

    public static SecurityContext getSecurityContext() {
        return SecurityContextHolder.getContext();
    }

    public static Authentication getAuthentication() {
        return SecurityUtils.getSecurityContext().getAuthentication();
    }

    public static boolean isAuthenticated() {
        return ObjectUtils.isNotEmpty((Object)SecurityUtils.getAuthentication()) && SecurityUtils.getAuthentication().isAuthenticated();
    }

    public static Object getDetails() {
        return SecurityUtils.getAuthentication().getDetails();
    }

    public static void reloadAuthority(HerodotusUser newHerodotusUser) {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)newHerodotusUser, (Object)newHerodotusUser.getPassword(), newHerodotusUser.getAuthorities());
        token.setDetails(SecurityUtils.getDetails());
        SecurityUtils.getSecurityContext().setAuthentication((Authentication)token);
    }

    public static HerodotusUser getPrincipal() {
        if (SecurityUtils.isAuthenticated()) {
            Authentication authentication = SecurityUtils.getAuthentication();
            if (authentication.getPrincipal() instanceof OAuth2IntrospectionAuthenticatedPrincipal) {
                OAuth2IntrospectionAuthenticatedPrincipal introspectionPrincipal = (OAuth2IntrospectionAuthenticatedPrincipal)authentication.getPrincipal();
                return new HerodotusUser(null, introspectionPrincipal.getUsername(), null, introspectionPrincipal.getAuthorities());
            }
            if (authentication.getPrincipal() instanceof HerodotusUser) {
                return (HerodotusUser)authentication.getPrincipal();
            }
            if (authentication.getPrincipal() instanceof Map) {
                Map principal = (Map)authentication.getPrincipal();
                return (HerodotusUser)BeanUtil.mapToBean((Map)principal, HerodotusUser.class, (boolean)true, (CopyOptions)new CopyOptions());
            }
        }
        return null;
    }

    public static String getUsername() {
        HerodotusUser user = SecurityUtils.getPrincipal();
        if (user != null) {
            return user.getUsername();
        }
        return null;
    }

    public static HerodotusUser getPrincipals() {
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        if (principal != null) {
            if (principal instanceof HerodotusUser) {
                return (HerodotusUser)principal;
            }
            if (principal instanceof LinkedHashMap) {
                return null;
            }
            if (principal instanceof String && principal.equals("anonymousUser")) {
                return null;
            }
            throw new IllegalStateException("\u83b7\u53d6\u7528\u6237\u6570\u636e\u5931\u8d25");
        }
        return null;
    }

    public static String getUserId() {
        HerodotusUser herodotusUser = SecurityUtils.getPrincipal();
        if (ObjectUtils.isNotEmpty((Object)herodotusUser)) {
            return herodotusUser.getUserId();
        }
        return null;
    }

    public static String[] whitelistToAntMatchers(List<String> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            String[] array = new String[list.size()];
            log.debug("[Herodotus] |- Fetch The REST White List.");
            return list.toArray(array);
        }
        log.warn("[Herodotus] |- Can not Fetch The REST White List Configurations.");
        return new String[0];
    }

    public static String wellFormRolePrefix(String content) {
        return SecurityUtils.wellFormPrefix(content, PREFIX_ROLE);
    }

    public static String wellFormPrefix(String content, String prefix) {
        if (StringUtils.startsWith((CharSequence)content, (CharSequence)prefix)) {
            return content;
        }
        return prefix + content;
    }
}

