/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.core.exception;

import cn.herodotus.engine.assistant.core.domain.Result;
import cn.herodotus.engine.assistant.core.enums.ResultErrorCodes;
import cn.herodotus.engine.assistant.core.exception.GlobalExceptionHandler;
import cn.herodotus.engine.assistant.core.exception.PlatformException;
import cn.herodotus.engine.oauth2.core.exception.PlatformAuthenticationException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;

@RestControllerAdvice
public class SecurityGlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(SecurityGlobalExceptionHandler.class);
    private static final Map<String, Result<String>> EXCEPTION_DICTIONARY = new HashMap<String, Result<String>>();

    @ExceptionHandler(value={HttpClientErrorException.class, HttpServerErrorException.class})
    public static Result<String> restTemplateException(Exception ex, HttpServletRequest request, HttpServletResponse response) {
        Result<String> result = SecurityGlobalExceptionHandler.resolveException(ex, request.getRequestURI());
        response.setStatus(result.getStatus());
        return result;
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public static Result<String> validationMethodArgumentException(MethodArgumentNotValidException ex, HttpServletRequest request, HttpServletResponse response) {
        return SecurityGlobalExceptionHandler.validationBindException((BindException)ex, request, response);
    }

    @ExceptionHandler(value={BindException.class})
    public static Result<String> validationBindException(BindException ex, HttpServletRequest request, HttpServletResponse response) {
        Result<String> result = SecurityGlobalExceptionHandler.resolveException((Exception)ex, request.getRequestURI());
        BindingResult bindingResult = ex.getBindingResult();
        FieldError fieldError = bindingResult.getFieldError();
        if (ObjectUtils.isNotEmpty((Object)fieldError)) {
            result.validation(fieldError.getDefaultMessage(), fieldError.getCode(), fieldError.getField());
        }
        response.setStatus(result.getStatus());
        return result;
    }

    @ExceptionHandler(value={AuthenticationException.class, PlatformAuthenticationException.class})
    public static Result<String> authenticationException(Exception ex, HttpServletRequest request, HttpServletResponse response) {
        Result<String> result = SecurityGlobalExceptionHandler.resolveSecurityException(ex, request.getRequestURI());
        response.setStatus(result.getStatus());
        return result;
    }

    @ExceptionHandler(value={OAuth2AuthenticationException.class})
    public static Result<String> oAuth2AuthenticationException(Exception ex, HttpServletRequest request, HttpServletResponse response) {
        Result<String> result = SecurityGlobalExceptionHandler.resolveSecurityException(ex, request.getRequestURI());
        response.setStatus(result.getStatus());
        return result;
    }

    @ExceptionHandler(value={Exception.class, PlatformException.class})
    public static Result<String> exception(Exception ex, HttpServletRequest request, HttpServletResponse response) {
        Result<String> result = SecurityGlobalExceptionHandler.resolveException(ex, request.getRequestURI());
        response.setStatus(result.getStatus());
        return result;
    }

    public static Result<String> resolveException(Exception ex, String path) {
        return GlobalExceptionHandler.resolveException((Exception)ex, (String)path);
    }

    public static Result<String> resolveSecurityException(Exception exception, String path) {
        Exception reason = new Exception();
        if (exception instanceof OAuth2AuthenticationException) {
            OAuth2AuthenticationException oAuth2AuthenticationException = (OAuth2AuthenticationException)exception;
            OAuth2Error oAuth2Error = oAuth2AuthenticationException.getError();
            if (EXCEPTION_DICTIONARY.containsKey(oAuth2Error.getErrorCode())) {
                Result<String> result = EXCEPTION_DICTIONARY.get(oAuth2Error.getErrorCode());
                result.path(oAuth2Error.getUri());
                result.stackTrace(exception.getStackTrace());
                result.detail(exception.getMessage());
                return result;
            }
        } else if (exception instanceof InsufficientAuthenticationException) {
            Throwable throwable = exception.getCause();
            reason = ObjectUtils.isNotEmpty((Object)throwable) ? new Exception(throwable) : exception;
            log.debug("[Herodotus] |- InsufficientAuthenticationException cause content is [{}]", (Object)reason.getClass().getSimpleName());
        } else {
            reason = exception;
        }
        return SecurityGlobalExceptionHandler.resolveException(reason, path);
    }

    static {
        EXCEPTION_DICTIONARY.put("access_denied", (Result<String>)GlobalExceptionHandler.getUnauthorizedResult((ResultErrorCodes)ResultErrorCodes.ACCESS_DENIED));
        EXCEPTION_DICTIONARY.put("insufficient_scope", (Result<String>)GlobalExceptionHandler.getForbiddenResult((ResultErrorCodes)ResultErrorCodes.INSUFFICIENT_SCOPE));
        EXCEPTION_DICTIONARY.put("invalid_client", (Result<String>)GlobalExceptionHandler.getPreconditionFailedResult((ResultErrorCodes)ResultErrorCodes.INVALID_CLIENT));
        EXCEPTION_DICTIONARY.put("invalid_grant", (Result<String>)GlobalExceptionHandler.getPreconditionFailedResult((ResultErrorCodes)ResultErrorCodes.INVALID_GRANT));
        EXCEPTION_DICTIONARY.put("invalid_redirect_uri", (Result<String>)GlobalExceptionHandler.getPreconditionFailedResult((ResultErrorCodes)ResultErrorCodes.INVALID_REDIRECT_URI));
        EXCEPTION_DICTIONARY.put("invalid_request", (Result<String>)GlobalExceptionHandler.getPreconditionFailedResult((ResultErrorCodes)ResultErrorCodes.INVALID_REQUEST));
        EXCEPTION_DICTIONARY.put("invalid_scope", (Result<String>)GlobalExceptionHandler.getPreconditionFailedResult((ResultErrorCodes)ResultErrorCodes.INVALID_SCOPE));
        EXCEPTION_DICTIONARY.put("invalid_token", (Result<String>)GlobalExceptionHandler.getUnauthorizedResult((ResultErrorCodes)ResultErrorCodes.INVALID_TOKEN));
        EXCEPTION_DICTIONARY.put("server_error", (Result<String>)GlobalExceptionHandler.getInternalServerErrorResult((ResultErrorCodes)ResultErrorCodes.SERVER_ERROR));
        EXCEPTION_DICTIONARY.put("temporarily_unavailable", (Result<String>)GlobalExceptionHandler.getServiceUnavailableResult((ResultErrorCodes)ResultErrorCodes.TEMPORARILY_UNAVAILABLE));
        EXCEPTION_DICTIONARY.put("unauthorized_client", (Result<String>)GlobalExceptionHandler.getUnauthorizedResult((ResultErrorCodes)ResultErrorCodes.UNAUTHORIZED_CLIENT));
        EXCEPTION_DICTIONARY.put("unsupported_grant_type", (Result<String>)GlobalExceptionHandler.getNotAcceptableResult((ResultErrorCodes)ResultErrorCodes.UNSUPPORTED_GRANT_TYPE));
        EXCEPTION_DICTIONARY.put("unsupported_response_type", (Result<String>)GlobalExceptionHandler.getNotAcceptableResult((ResultErrorCodes)ResultErrorCodes.UNSUPPORTED_RESPONSE_TYPE));
        EXCEPTION_DICTIONARY.put("unsupported_token_type", (Result<String>)GlobalExceptionHandler.getNotAcceptableResult((ResultErrorCodes)ResultErrorCodes.UNSUPPORTED_TOKEN_TYPE));
        EXCEPTION_DICTIONARY.put("AccountExpiredException", (Result<String>)GlobalExceptionHandler.getUnauthorizedResult((ResultErrorCodes)ResultErrorCodes.ACCOUNT_EXPIRED));
        EXCEPTION_DICTIONARY.put("BadCredentialsException", (Result<String>)GlobalExceptionHandler.getUnauthorizedResult((ResultErrorCodes)ResultErrorCodes.BAD_CREDENTIALS));
        EXCEPTION_DICTIONARY.put("CredentialsExpiredException", (Result<String>)GlobalExceptionHandler.getUnauthorizedResult((ResultErrorCodes)ResultErrorCodes.CREDENTIALS_EXPIRED));
        EXCEPTION_DICTIONARY.put("DisabledException", (Result<String>)GlobalExceptionHandler.getUnauthorizedResult((ResultErrorCodes)ResultErrorCodes.ACCOUNT_DISABLED));
        EXCEPTION_DICTIONARY.put("LockedException", (Result<String>)GlobalExceptionHandler.getUnauthorizedResult((ResultErrorCodes)ResultErrorCodes.ACCOUNT_LOCKED));
        EXCEPTION_DICTIONARY.put("AccountEndpointLimitedException", (Result<String>)GlobalExceptionHandler.getUnauthorizedResult((ResultErrorCodes)ResultErrorCodes.ACCOUNT_ENDPOINT_LIMITED));
        EXCEPTION_DICTIONARY.put("UsernameNotFoundException", (Result<String>)GlobalExceptionHandler.getUnauthorizedResult((ResultErrorCodes)ResultErrorCodes.USERNAME_NOT_FOUND));
        EXCEPTION_DICTIONARY.put("SessionExpiredException", (Result<String>)GlobalExceptionHandler.getUnauthorizedResult((ResultErrorCodes)ResultErrorCodes.USERNAME_NOT_FOUND));
    }
}

