/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.core.definition.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.List;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class HerodotusSecurityConfig
implements ConfigAttribute {
    private final String attrib;

    public HerodotusSecurityConfig(String config) {
        Assert.hasText((String)config, (String)"You must provide a configuration attribute");
        this.attrib = config;
    }

    public String getAttribute() {
        return this.attrib;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HerodotusSecurityConfig that = (HerodotusSecurityConfig)o;
        return Objects.equal((Object)this.attrib, (Object)that.attrib);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.attrib});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("attrib", (Object)this.attrib).toString();
    }

    public static List<ConfigAttribute> createListFromCommaDelimitedString(String access) {
        return HerodotusSecurityConfig.createList(StringUtils.commaDelimitedListToStringArray((String)access));
    }

    public static List<ConfigAttribute> createList(String ... attributeNames) {
        Assert.notNull((Object)attributeNames, (String)"You must supply an array of attribute names");
        ArrayList<ConfigAttribute> attributes = new ArrayList<ConfigAttribute>(attributeNames.length);
        for (String attribute : attributeNames) {
            attributes.add(new HerodotusSecurityConfig(attribute.trim()));
        }
        return attributes;
    }
}

