/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.core.enums;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableMap;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Schema(name="\u7b7e\u540d\u7b97\u6cd5")
@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public enum Signature {
    RS256(0, "RS256"),
    RS384(1, "RS384"),
    RS512(2, "RS512"),
    ES256(3, "ES256"),
    ES384(4, "ES384"),
    ES512(5, "ES512"),
    PS256(6, "PS256"),
    PS384(7, "PS384"),
    PS512(8, "PS512");

    @Schema(name="\u7d22\u5f15")
    private final Integer index;
    @Schema(name="\u6587\u5b57")
    private final String algorithm;
    private static final Map<Integer, Signature> indexMap;
    private static final List<Map<String, Object>> toJsonStruct;

    private Signature(Integer index, String algorithm) {
        this.index = index;
        this.algorithm = algorithm;
    }

    @JsonValue
    public Integer getIndex() {
        return this.index;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public static Signature getSignatureAlgorithm(Integer type) {
        return indexMap.get(type);
    }

    public static List<Map<String, Object>> getToJsonStruct() {
        return toJsonStruct;
    }

    static {
        indexMap = new HashMap<Integer, Signature>();
        toJsonStruct = new ArrayList<Map<String, Object>>();
        for (Signature signature : Signature.values()) {
            indexMap.put(signature.ordinal(), signature);
            toJsonStruct.add(signature.ordinal(), (Map<String, Object>)ImmutableMap.builder().put((Object)"value", (Object)signature.ordinal()).put((Object)"key", (Object)signature.name()).put((Object)"text", (Object)signature.getAlgorithm()).build());
        }
    }
}

