/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.core.enums;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum GrantType {
    AUTHORIZATION_CODE("authorization_code", "Authorization Code \u6a21\u5f0f"),
    PASSWORD("password", "Password \u6a21\u5f0f"),
    CLIENT_CREDENTIALS("client_credentials", "Client Credentials \u6a21\u5f0f"),
    REFRESH_TOKEN("refresh_token", "Refresh Token \u6a21\u5f0f"),
    SOCIAL_AUTHENTICATION("social_credentials", "Social Credentials \u6a21\u5f0f");

    private final String grant;
    private final String description;
    private static final Map<Integer, GrantType> indexMap;
    private static final List<Map<String, Object>> toJsonStruct;

    private GrantType(String grant, String description) {
        this.grant = grant;
        this.description = description;
    }

    public String getGrant() {
        return this.grant;
    }

    public String getDescription() {
        return this.description;
    }

    public static GrantType getGrant(Integer grant) {
        return indexMap.get(grant);
    }

    public static List<Map<String, Object>> getToJsonStruct() {
        return toJsonStruct;
    }

    static {
        indexMap = new HashMap<Integer, GrantType>();
        toJsonStruct = new ArrayList<Map<String, Object>>();
        for (GrantType grantType : GrantType.values()) {
            indexMap.put(grantType.ordinal(), grantType);
            toJsonStruct.add(grantType.ordinal(), (Map<String, Object>)ImmutableMap.builder().put((Object)"value", (Object)grantType.getGrant()).put((Object)"key", (Object)grantType.name()).put((Object)"text", (Object)grantType.getDescription()).put((Object)"index", (Object)grantType.ordinal()).build());
        }
    }
}

