/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.core.enums;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;

public enum AuthenticationMethod {
    CLIENT_SECRET_BASIC(ClientAuthenticationMethod.CLIENT_SECRET_BASIC.getValue(), "\u57fa\u4e8eClient Secret\u7684Basic\u9a8c\u8bc1\u6a21\u5f0f"),
    CLIENT_SECRET_POST(ClientAuthenticationMethod.CLIENT_SECRET_POST.getValue(), "\u57fa\u4e8eClient Secret\u7684Post\u9a8c\u8bc1\u6a21\u5f0f"),
    CLIENT_SECRET_JWT(ClientAuthenticationMethod.CLIENT_SECRET_JWT.getValue(), "\u57fa\u4e8eClient Secret\u7684JWT\u9a8c\u8bc1\u6a21\u5f0f"),
    PRIVATE_KEY_JWT(ClientAuthenticationMethod.PRIVATE_KEY_JWT.getValue(), "\u57fa\u4e8e\u79c1\u94a5\u7684JWT\u9a8c\u8bc1\u6a21\u5f0f"),
    NONE(ClientAuthenticationMethod.NONE.getValue(), "\u4e0d\u8bbe\u7f6e\u4efb\u4f55\u6a21\u5f0f");

    private final String method;
    private final String description;
    private static final Map<Integer, AuthenticationMethod> indexMap;
    private static final List<Map<String, Object>> toJsonStruct;

    private AuthenticationMethod(String method, String description) {
        this.method = method;
        this.description = description;
    }

    public String getMethod() {
        return this.method;
    }

    public String getDescription() {
        return this.description;
    }

    public static AuthenticationMethod getAuthenticationMethod(Integer grant) {
        return indexMap.get(grant);
    }

    public static List<Map<String, Object>> getToJsonStruct() {
        return toJsonStruct;
    }

    static {
        indexMap = new HashMap<Integer, AuthenticationMethod>();
        toJsonStruct = new ArrayList<Map<String, Object>>();
        for (AuthenticationMethod grantType : AuthenticationMethod.values()) {
            indexMap.put(grantType.ordinal(), grantType);
            toJsonStruct.add(grantType.ordinal(), (Map<String, Object>)ImmutableMap.builder().put((Object)"value", (Object)grantType.getMethod()).put((Object)"key", (Object)grantType.name()).put((Object)"text", (Object)grantType.getDescription()).put((Object)"index", (Object)grantType.ordinal()).build());
        }
    }
}

