/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.core.processor;

import cn.herodotus.engine.oauth2.core.properties.SecurityProperties;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class HerodotusSecurityConfigureHandler {
    private static final List<String> DEFAULT_IGNORED_STATIC_RESOURCES = Lists.newArrayList((Object[])new String[]{"/error/**", "/plugins/**", "/authorization/**", "/static/**", "/webjars/**", "/swagger-ui.html", "/swagger-ui/**", "/swagger-resources/**", "/v3/api-docs", "/v3/api-docs/**", "/openapi.json", "/favicon.ico"});
    private static final List<String> DEFAULT_PERMIT_ALL_RESOURCES = Lists.newArrayList((Object[])new String[]{"/open/**"});
    private List<String> staticResources;
    private List<String> permitAllResources;
    private final SecurityProperties securityProperties;

    public HerodotusSecurityConfigureHandler(SecurityProperties securityProperties) {
        this.securityProperties = securityProperties;
        this.staticResources = new ArrayList<String>();
        this.permitAllResources = new ArrayList<String>();
    }

    public List<String> getStaticResourceList() {
        if (CollectionUtils.isEmpty(this.staticResources)) {
            this.staticResources = this.merge(this.securityProperties.getMatcher().getStaticResources(), DEFAULT_IGNORED_STATIC_RESOURCES);
        }
        return this.staticResources;
    }

    public List<String> getPermitAllList() {
        if (CollectionUtils.isEmpty(this.permitAllResources)) {
            this.permitAllResources = this.merge(this.securityProperties.getMatcher().getPermitAll(), DEFAULT_PERMIT_ALL_RESOURCES);
        }
        return this.permitAllResources;
    }

    public String[] getStaticResourceArray() {
        return this.convertToArray(this.getStaticResourceList());
    }

    public String[] getPermitAllArray() {
        return this.convertToArray(this.getPermitAllList());
    }

    private List<String> merge(List<String> customResources, List<String> defaultResources) {
        if (CollectionUtils.isEmpty(customResources)) {
            return defaultResources;
        }
        return CollectionUtils.collate(customResources, defaultResources);
    }

    private String[] convertToArray(List<String> resources) {
        if (CollectionUtils.isNotEmpty(resources)) {
            String[] result = new String[resources.size()];
            return resources.toArray(result);
        }
        return new String[0];
    }
}

