/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.authorization.autoconfigure.customizer;

import cn.herodotus.engine.oauth2.authentication.consumer.OAuth2AuthorizationCodeAuthenticationProviderConsumer;
import cn.herodotus.engine.oauth2.authentication.consumer.OAuth2ClientCredentialsAuthenticationProviderConsumer;
import cn.herodotus.engine.oauth2.authentication.oidc.HerodotusOidcUserInfoMapper;
import cn.herodotus.engine.oauth2.authentication.provider.OAuth2ResourceOwnerPasswordAuthenticationConverter;
import cn.herodotus.engine.oauth2.authentication.provider.OAuth2SocialCredentialsAuthenticationConverter;
import cn.herodotus.engine.oauth2.authentication.response.OAuth2AuthenticationFailureResponseHandler;
import cn.herodotus.engine.oauth2.core.definition.service.ClientDetailsService;
import cn.herodotus.engine.oauth2.management.response.OAuth2AccessTokenResponseHandler;
import cn.herodotus.engine.oauth2.management.response.OAuth2DeviceVerificationResponseHandler;
import cn.herodotus.engine.oauth2.management.response.OidcClientRegistrationResponseHandler;
import cn.herodotus.engine.rest.protect.crypto.processor.HttpCryptoProcessor;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OAuth2AuthorizationServerConfigurer;
import org.springframework.security.oauth2.server.authorization.web.authentication.OAuth2AuthorizationCodeAuthenticationConverter;
import org.springframework.security.oauth2.server.authorization.web.authentication.OAuth2ClientCredentialsAuthenticationConverter;
import org.springframework.security.oauth2.server.authorization.web.authentication.OAuth2DeviceCodeAuthenticationConverter;
import org.springframework.security.oauth2.server.authorization.web.authentication.OAuth2RefreshTokenAuthenticationConverter;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.DelegatingAuthenticationConverter;

public class OAuth2AuthorizationServerConfigurerCustomizer
implements Customizer<OAuth2AuthorizationServerConfigurer> {
    private final HttpSecurity httpSecurity;
    private final SessionRegistry sessionRegistry;
    private final ClientDetailsService clientDetailsService;
    private final HttpCryptoProcessor httpCryptoProcessor;
    private final OidcClientRegistrationResponseHandler oidcClientRegistrationResponseHandler;
    private final OAuth2AuthenticationFailureResponseHandler oauth2AuthenticationFailureResponseHandler;
    private final OAuth2DeviceVerificationResponseHandler oauth2DeviceVerificationResponseHandler;

    public OAuth2AuthorizationServerConfigurerCustomizer(HttpSecurity httpSecurity, SessionRegistry sessionRegistry, ClientDetailsService clientDetailsService, HttpCryptoProcessor httpCryptoProcessor, OidcClientRegistrationResponseHandler oidcClientRegistrationResponseHandler, OAuth2DeviceVerificationResponseHandler oauth2DeviceVerificationResponseHandler) {
        this.httpSecurity = httpSecurity;
        this.sessionRegistry = sessionRegistry;
        this.clientDetailsService = clientDetailsService;
        this.httpCryptoProcessor = httpCryptoProcessor;
        this.oidcClientRegistrationResponseHandler = oidcClientRegistrationResponseHandler;
        this.oauth2DeviceVerificationResponseHandler = oauth2DeviceVerificationResponseHandler;
        this.oauth2AuthenticationFailureResponseHandler = new OAuth2AuthenticationFailureResponseHandler();
    }

    public void customize(OAuth2AuthorizationServerConfigurer oauth2AuthorizationServerConfigurer) {
        oauth2AuthorizationServerConfigurer.clientAuthentication(endpoint -> {
            endpoint.errorResponseHandler((AuthenticationFailureHandler)this.oauth2AuthenticationFailureResponseHandler);
            endpoint.authenticationProviders((Consumer)new OAuth2ClientCredentialsAuthenticationProviderConsumer(this.httpSecurity, this.clientDetailsService));
        }).authorizationEndpoint(endpoint -> {
            endpoint.errorResponseHandler((AuthenticationFailureHandler)this.oauth2AuthenticationFailureResponseHandler);
            endpoint.consentPage("/oauth2/consent");
        }).deviceAuthorizationEndpoint(endpoint -> {
            endpoint.errorResponseHandler((AuthenticationFailureHandler)this.oauth2AuthenticationFailureResponseHandler);
            endpoint.verificationUri("/oauth2/device_activation");
        }).deviceVerificationEndpoint(endpoint -> {
            endpoint.errorResponseHandler((AuthenticationFailureHandler)this.oauth2AuthenticationFailureResponseHandler);
            endpoint.consentPage("/oauth2/consent");
            endpoint.deviceVerificationResponseHandler((AuthenticationSuccessHandler)this.oauth2DeviceVerificationResponseHandler);
        }).tokenEndpoint(endpoint -> {
            DelegatingAuthenticationConverter authenticationConverter = new DelegatingAuthenticationConverter(Arrays.asList(new OAuth2AuthorizationCodeAuthenticationConverter(), new OAuth2RefreshTokenAuthenticationConverter(), new OAuth2ClientCredentialsAuthenticationConverter(), new OAuth2DeviceCodeAuthenticationConverter(), new OAuth2ResourceOwnerPasswordAuthenticationConverter(this.httpCryptoProcessor), new OAuth2SocialCredentialsAuthenticationConverter(this.httpCryptoProcessor)));
            endpoint.accessTokenRequestConverter((AuthenticationConverter)authenticationConverter);
            endpoint.errorResponseHandler((AuthenticationFailureHandler)this.oauth2AuthenticationFailureResponseHandler);
            endpoint.accessTokenResponseHandler((AuthenticationSuccessHandler)new OAuth2AccessTokenResponseHandler(this.httpCryptoProcessor));
            endpoint.authenticationProviders((Consumer)new OAuth2AuthorizationCodeAuthenticationProviderConsumer(this.httpSecurity, this.sessionRegistry));
        }).tokenIntrospectionEndpoint(endpoint -> endpoint.errorResponseHandler((AuthenticationFailureHandler)this.oauth2AuthenticationFailureResponseHandler)).tokenRevocationEndpoint(endpoint -> endpoint.errorResponseHandler((AuthenticationFailureHandler)this.oauth2AuthenticationFailureResponseHandler)).oidc(oidc -> oidc.clientRegistrationEndpoint(endpoint -> {
            endpoint.errorResponseHandler((AuthenticationFailureHandler)this.oauth2AuthenticationFailureResponseHandler);
            endpoint.clientRegistrationResponseHandler((AuthenticationSuccessHandler)this.oidcClientRegistrationResponseHandler);
        }).userInfoEndpoint(userInfo -> userInfo.userInfoMapper((Function)new HerodotusOidcUserInfoMapper())));
    }
}

