/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.authentication.autoconfigure.customizer;

import cn.herodotus.engine.core.identity.service.ClientDetailsService;
import cn.herodotus.engine.oauth2.authentication.configurer.OAuth2AuthenticationConfigurerManager;
import cn.herodotus.engine.oauth2.authentication.consumer.OAuth2TokenEndpointAuthenticationProviderConsumer;
import cn.herodotus.engine.oauth2.authentication.customizer.HerodotusOidcUserInfoMapper;
import cn.herodotus.engine.oauth2.authentication.provider.OAuth2ResourceOwnerPasswordAuthenticationConverter;
import cn.herodotus.engine.oauth2.authentication.provider.OAuth2SocialCredentialsAuthenticationConverter;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OAuth2AuthorizationServerConfigurer;
import org.springframework.security.oauth2.server.authorization.web.authentication.OAuth2AuthorizationCodeAuthenticationConverter;
import org.springframework.security.oauth2.server.authorization.web.authentication.OAuth2ClientCredentialsAuthenticationConverter;
import org.springframework.security.oauth2.server.authorization.web.authentication.OAuth2DeviceCodeAuthenticationConverter;
import org.springframework.security.oauth2.server.authorization.web.authentication.OAuth2RefreshTokenAuthenticationConverter;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.DelegatingAuthenticationConverter;

public class OAuth2AuthorizationServerConfigurerCustomizer
implements Customizer<OAuth2AuthorizationServerConfigurer> {
    private final HttpSecurity httpSecurity;
    private final SessionRegistry sessionRegistry;
    private final ClientDetailsService clientDetailsService;
    private final OAuth2AuthenticationConfigurerManager authenticationConfigurerManager;

    public OAuth2AuthorizationServerConfigurerCustomizer(HttpSecurity httpSecurity, SessionRegistry sessionRegistry, ClientDetailsService clientDetailsService, OAuth2AuthenticationConfigurerManager authenticationConfigurerManager) {
        this.httpSecurity = httpSecurity;
        this.sessionRegistry = sessionRegistry;
        this.clientDetailsService = clientDetailsService;
        this.authenticationConfigurerManager = authenticationConfigurerManager;
    }

    public void customize(OAuth2AuthorizationServerConfigurer oauth2AuthorizationServerConfigurer) {
        oauth2AuthorizationServerConfigurer.clientAuthentication(endpoint -> endpoint.errorResponseHandler((AuthenticationFailureHandler)this.authenticationConfigurerManager.getOAuth2AuthenticationFailureHandler())).authorizationEndpoint(endpoint -> {
            endpoint.errorResponseHandler((AuthenticationFailureHandler)this.authenticationConfigurerManager.getOAuth2AuthenticationFailureHandler());
            endpoint.consentPage("/oauth2/consent");
        }).deviceAuthorizationEndpoint(endpoint -> {
            endpoint.errorResponseHandler((AuthenticationFailureHandler)this.authenticationConfigurerManager.getOAuth2AuthenticationFailureHandler());
            endpoint.verificationUri("/oauth2/device_activation");
        }).deviceVerificationEndpoint(endpoint -> {
            endpoint.errorResponseHandler((AuthenticationFailureHandler)this.authenticationConfigurerManager.getOAuth2AuthenticationFailureHandler());
            endpoint.consentPage("/oauth2/consent");
        }).tokenEndpoint(endpoint -> {
            DelegatingAuthenticationConverter authenticationConverter = new DelegatingAuthenticationConverter(Arrays.asList(new OAuth2AuthorizationCodeAuthenticationConverter(), new OAuth2RefreshTokenAuthenticationConverter(), new OAuth2ClientCredentialsAuthenticationConverter(), new OAuth2DeviceCodeAuthenticationConverter(), new OAuth2ResourceOwnerPasswordAuthenticationConverter(this.authenticationConfigurerManager.getHttpCryptoProcessor()), new OAuth2SocialCredentialsAuthenticationConverter(this.authenticationConfigurerManager.getHttpCryptoProcessor())));
            endpoint.accessTokenRequestConverter((AuthenticationConverter)authenticationConverter);
            endpoint.errorResponseHandler((AuthenticationFailureHandler)this.authenticationConfigurerManager.getOAuth2AuthenticationFailureHandler());
            endpoint.accessTokenResponseHandler((AuthenticationSuccessHandler)this.authenticationConfigurerManager.getOAuth2AccessTokenResponseHandler());
            endpoint.authenticationProviders((Consumer)new OAuth2TokenEndpointAuthenticationProviderConsumer(this.httpSecurity, this.sessionRegistry, this.clientDetailsService));
        }).tokenIntrospectionEndpoint(endpoint -> endpoint.errorResponseHandler((AuthenticationFailureHandler)this.authenticationConfigurerManager.getOAuth2AuthenticationFailureHandler())).tokenRevocationEndpoint(endpoint -> endpoint.errorResponseHandler((AuthenticationFailureHandler)this.authenticationConfigurerManager.getOAuth2AuthenticationFailureHandler())).oidc(oidc -> oidc.clientRegistrationEndpoint(endpoint -> endpoint.errorResponseHandler((AuthenticationFailureHandler)this.authenticationConfigurerManager.getOAuth2AuthenticationFailureHandler())).userInfoEndpoint(userInfo -> userInfo.userInfoMapper((Function)new HerodotusOidcUserInfoMapper())));
    }
}

