/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.nosql.influxdb.condition;

import cn.herodotus.engine.assistant.core.support.PropertyResolver;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class InfluxdbEnabledCondition
implements Condition {
    private static final Logger log = LoggerFactory.getLogger(InfluxdbEnabledCondition.class);

    public boolean matches(ConditionContext conditionContext, AnnotatedTypeMetadata metadata) {
        String url = PropertyResolver.getProperty((ConditionContext)conditionContext, (String)"herodotus.nosql.influxdb.endpoint");
        String database = PropertyResolver.getProperty((ConditionContext)conditionContext, (String)"herodotus.nosql.influxdb.database");
        String username = PropertyResolver.getProperty((ConditionContext)conditionContext, (String)"herodotus.nosql.influxdb.username");
        String password = PropertyResolver.getProperty((ConditionContext)conditionContext, (String)"herodotus.nosql.influxdb.password");
        boolean result = StringUtils.isNotBlank((CharSequence)url) && StringUtils.isNotBlank((CharSequence)database) && StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)password);
        log.debug("[Herodotus] |- Condition [Influxdb Enabled] value is [{}]", (Object)result);
        return result;
    }
}

