/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.nosql.influxdb.support;

import org.influxdb.InfluxDB;
import org.influxdb.dto.Pong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class InfluxdbTemplate {
    private static final Logger log = LoggerFactory.getLogger(InfluxdbTemplate.class);
    private final InfluxDB influxdb;

    public InfluxdbTemplate(InfluxDB influxdb) {
        this.influxdb = influxdb;
    }

    public boolean ping() {
        boolean isConnected = false;
        try {
            Pong pong = this.influxdb.ping();
            if (pong != null) {
                isConnected = true;
            }
        }
        catch (Exception e) {
            log.error("[Herodotus] |- Influxdb ping the connection error.", (Throwable)e);
        }
        return isConnected;
    }
}

