/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.nosql.influxdb.configuration;

import cn.herodotus.engine.nosql.influxdb.annotation.ConditionalOnInfluxdbEnabled;
import cn.herodotus.engine.nosql.influxdb.properties.InfluxdbProperties;
import cn.herodotus.engine.nosql.influxdb.support.InfluxdbTemplate;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnInfluxdbEnabled
@EnableConfigurationProperties(value={InfluxdbProperties.class})
public class InfluxdbConfiguration {
    private static final Logger log = LoggerFactory.getLogger(InfluxdbConfiguration.class);

    @PostConstruct
    public void init() {
        log.info("[Herodotus] |- Plugin [Herodotus Influxdb] Auto Configure.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Bean
    public InfluxDB influxdb(InfluxdbProperties influxdbProperties) {
        InfluxDB influxdb = StringUtils.isNotBlank((CharSequence)influxdbProperties.getUsername()) && StringUtils.isNotBlank((CharSequence)influxdbProperties.getPassword()) ? InfluxDBFactory.connect((String)influxdbProperties.getEndpoint(), (String)influxdbProperties.getUsername(), (String)influxdbProperties.getPassword()) : InfluxDBFactory.connect((String)influxdbProperties.getEndpoint());
        try {
            influxdb.setDatabase(influxdbProperties.getDatabase()).enableBatch(100, 2000, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            log.error("[Herodotus] |- Influxdb set database catch error.", (Throwable)e);
        }
        finally {
            influxdb.setRetentionPolicy("autogen");
        }
        influxdb.setLogLevel(InfluxDB.LogLevel.BASIC);
        return influxdb;
    }

    @Bean
    @ConditionalOnBean(value={InfluxDB.class})
    public InfluxdbTemplate influxdbTemplate(InfluxDB influxdb) {
        InfluxdbTemplate influxdbTemplate = new InfluxdbTemplate(influxdb);
        log.trace("[Herodotus] |- Bean [Influxdb Template Auto Configure.");
        return influxdbTemplate;
    }
}

