/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.nosql.couchdb.definition;

import cn.herodotus.engine.assistant.core.definition.http.AbstractRest;
import cn.herodotus.engine.nosql.couchdb.properties.CouchdbProperties;
import cn.hutool.core.codec.Base64;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public abstract class AbstractCouchdbService
extends AbstractRest {
    private static final Logger log = LoggerFactory.getLogger(AbstractCouchdbService.class);
    @Autowired
    private CouchdbProperties couchdbProperties;

    protected String getBaseUrl() {
        return this.couchdbProperties.getEndpoint();
    }

    private String getBasicToken() {
        Assert.hasText((String)this.couchdbProperties.getUsername(), (String)"username cannot be empty");
        Assert.hasText((String)this.couchdbProperties.getPassword(), (String)"password cannot be empty");
        String content = this.couchdbProperties.getUsername() + ":" + this.couchdbProperties.getPassword();
        String token = "Basic " + Base64.encode((CharSequence)content);
        log.debug("[Herodotus] |- Create CouchDB Basic Authentication Token : [{}]", (Object)token);
        return token;
    }

    protected Map<String, String> getBasicAuthentication() {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", this.getBasicToken());
        return header;
    }
}

