/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.message.configuartion;

import cn.herodotus.engine.message.core.annotation.ConditionalOnKafkaEnabled;
import cn.herodotus.engine.message.core.properties.QueueProperties;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;

@Configuration(proxyBeanMethods=false)
@ConditionalOnKafkaEnabled
public class KafkaConfiguration {
    private static final Logger log = LoggerFactory.getLogger(KafkaConfiguration.class);
    @Autowired
    private QueueProperties queueProperties;
    @Autowired
    private ConsumerFactory<String, String> consumerFactory;

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- SDK [Engine Message Kafka] Auto Configure.");
    }

    @Bean
    @ConditionalOnMissingBean(value={ConcurrentKafkaListenerContainerFactory.class})
    public ConcurrentKafkaListenerContainerFactory<String, String> concurrentKafkaListenerContainerFactory() {
        ConcurrentKafkaListenerContainerFactory concurrentKafkaListenerContainerFactory = new ConcurrentKafkaListenerContainerFactory();
        concurrentKafkaListenerContainerFactory.setConsumerFactory(this.consumerFactory);
        concurrentKafkaListenerContainerFactory.setAutoStartup(this.queueProperties.getKafka().getEnabled());
        log.trace("[Herodotus] |- Bean [Concurrent Kafka Listener ContainerFactory] Auto Configure.");
        return concurrentKafkaListenerContainerFactory;
    }
}

