/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.message.mqtt.handler;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.MessagingException;

public class MqttMessageReceivingHandler
implements MessageHandler {
    private static final Logger log = LoggerFactory.getLogger(MqttMessageReceivingHandler.class);

    public void handleMessage(Message<?> message) throws MessagingException {
        MessageHeaders headers = message.getHeaders();
        String receivedTopic = (String)headers.get((Object)"mqtt_receivedTopic");
        log.info("\u83b7\u53d6\u5230v5\u7684\u6d88\u606f\u7684topic :{} ", (Object)receivedTopic);
        String responseTopic = (String)headers.get((Object)"mqtt_responseTopic");
        log.info("\u83b7\u53d6\u5230v5\u7684\u6d88\u606f\u7684\u54cd\u5e94\u4e3b\u9898 :{} ", (Object)responseTopic);
        String correlationData = null;
        if (Objects.nonNull(headers.get((Object)"mqtt_correlationData"))) {
            correlationData = new String((byte[])headers.get((Object)"mqtt_correlationData"), StandardCharsets.UTF_8);
            log.info("\u83b7\u53d6\u5230v5\u7684\u6d88\u606f\u5173\u8054\u6570\u636e :{} ", (Object)correlationData);
        }
        String payload = new String((byte[])message.getPayload(), StandardCharsets.UTF_8);
        log.info("\u83b7\u53d6\u5230v5\u7684\u6d88\u606f\u7684payload :{} ", (Object)payload);
    }
}

