/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.message.mqtt.configuration;

import cn.herodotus.engine.assistant.core.utils.type.ListUtils;
import cn.herodotus.engine.assistant.core.utils.type.NumberUtils;
import cn.herodotus.engine.message.mqtt.annotation.ConditionalOnMqttEnabled;
import cn.herodotus.engine.message.mqtt.handler.MqttMessageReceivingHandler;
import cn.herodotus.engine.message.mqtt.properties.MqttProperties;
import jakarta.annotation.PostConstruct;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.dromara.hutool.core.util.ByteUtil;
import org.eclipse.paho.mqttv5.client.IMqttAsyncClient;
import org.eclipse.paho.mqttv5.client.MqttClientPersistence;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptions;
import org.eclipse.paho.mqttv5.client.persist.MqttDefaultFilePersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.annotation.IntegrationComponentScan;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.dsl.MessageChannels;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.integration.mqtt.core.ClientManager;
import org.springframework.integration.mqtt.core.Mqttv5ClientManager;
import org.springframework.integration.mqtt.inbound.Mqttv5PahoMessageDrivenChannelAdapter;
import org.springframework.integration.mqtt.outbound.Mqttv5PahoMessageHandler;
import org.springframework.integration.mqtt.support.MqttHeaderMapper;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.Assert;

@Configuration(proxyBeanMethods=false)
@ConditionalOnMqttEnabled
@EnableConfigurationProperties(value={MqttProperties.class})
@IntegrationComponentScan(basePackages={"cn.herodotus.engine.message.mqtt.gateway"})
@ComponentScan(basePackages={"cn.herodotus.engine.message.mqtt.messaging"})
public class MessageMqttConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MessageMqttConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- SDK [Message Mqtt] Auto Configure.");
    }

    @Bean
    public MessageChannel mqtt5InboundChannel() {
        return (MessageChannel)MessageChannels.publishSubscribe().getObject();
    }

    @Bean
    public MessageChannel mqtt5OutboundChannel() {
        return (MessageChannel)MessageChannels.direct().getObject();
    }

    @Bean
    public ClientManager<IMqttAsyncClient, MqttConnectionOptions> clientManager(MqttProperties mqttProperties) {
        MqttConnectionOptions mqttConnectionOptions = new MqttConnectionOptions();
        mqttConnectionOptions.setUserName(mqttProperties.getUsername());
        mqttConnectionOptions.setPassword(ByteUtil.toBytes((CharSequence)mqttProperties.getPassword(), (Charset)StandardCharsets.UTF_8));
        mqttConnectionOptions.setCleanStart(mqttProperties.getCleanStart().booleanValue());
        mqttConnectionOptions.setKeepAliveInterval(NumberUtils.longToInt((long)mqttProperties.getKeepAliveInterval().getSeconds()));
        mqttConnectionOptions.setServerURIs(ListUtils.toStringArray(mqttProperties.getServerUrls()));
        mqttConnectionOptions.setAutomaticReconnect(mqttProperties.getAutomaticReconnect().booleanValue());
        mqttConnectionOptions.setAutomaticReconnectDelay(NumberUtils.longToInt((long)mqttProperties.getAutomaticReconnectMinDelay().getSeconds()), NumberUtils.longToInt((long)mqttProperties.getAutomaticReconnectMaxDelay().getSeconds()));
        Mqttv5ClientManager clientManager = new Mqttv5ClientManager(mqttConnectionOptions, mqttProperties.getClientId());
        clientManager.setPersistence((MqttClientPersistence)new MqttDefaultFilePersistence());
        log.trace("[Herodotus] |- Bean [Mqtt Connection Options] Auto Configure.");
        return clientManager;
    }

    @Bean
    public MessageProducer mqttInbound(ClientManager<IMqttAsyncClient, MqttConnectionOptions> clientManager, MessageChannel mqtt5InboundChannel, MqttProperties mqttProperties) {
        Assert.notNull(mqttProperties.getSubscribes(), (String)"'Property Subscribes' cannot be null");
        Mqttv5PahoMessageDrivenChannelAdapter messageProducer = new Mqttv5PahoMessageDrivenChannelAdapter(clientManager, ListUtils.toStringArray(mqttProperties.getSubscribes()));
        messageProducer.setPayloadType(String.class);
        messageProducer.setManualAcks(false);
        messageProducer.setOutputChannel(mqtt5InboundChannel);
        log.trace("[Herodotus] |- Bean [Mqtt v5 Paho Message Driven Channel Adapter] Auto Configure.");
        return messageProducer;
    }

    @Bean
    @ServiceActivator(inputChannel="mqtt5OutboundChannel")
    public MessageHandler mqttOutbound(ClientManager<IMqttAsyncClient, MqttConnectionOptions> clientManager, MqttProperties mqttProperties) {
        Mqttv5PahoMessageHandler messageHandler = new Mqttv5PahoMessageHandler(clientManager);
        MqttHeaderMapper mqttHeaderMapper = new MqttHeaderMapper();
        mqttHeaderMapper.setOutboundHeaderNames(new String[]{"mqtt_responseTopic", "mqtt_correlationData", "contentType"});
        messageHandler.setHeaderMapper((HeaderMapper)mqttHeaderMapper);
        messageHandler.setDefaultTopic(mqttProperties.getDefaultTopic());
        messageHandler.setDefaultQos(mqttProperties.getDefaultQos().intValue());
        messageHandler.setAsync(true);
        messageHandler.setAsyncEvents(true);
        log.trace("[Herodotus] |- Bean [Mqtt v5 Paho Message Handler] Auto Configure.");
        return messageHandler;
    }

    @Bean
    @ServiceActivator(inputChannel="mqtt5InboundChannel")
    public MessageHandler mqttInboundHandler() {
        MqttMessageReceivingHandler messageHandler = new MqttMessageReceivingHandler();
        log.trace("[Herodotus] |- Bean [Mqtt Message Receiving Handler] Auto Configure.");
        return messageHandler;
    }
}

