/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.message.mqtt.configuration;

import cn.herodotus.engine.assistant.core.utils.type.ListUtils;
import cn.herodotus.engine.message.mqtt.properties.MqttProperties;
import jakarta.annotation.PostConstruct;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import org.dromara.hutool.core.util.ByteUtil;
import org.eclipse.paho.mqttv5.client.IMqttAsyncClient;
import org.eclipse.paho.mqttv5.client.MqttClientPersistence;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptions;
import org.eclipse.paho.mqttv5.client.persist.MqttDefaultFilePersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.mqtt.core.ClientManager;
import org.springframework.integration.mqtt.core.Mqttv5ClientManager;
import org.springframework.integration.mqtt.inbound.Mqttv5PahoMessageDrivenChannelAdapter;
import org.springframework.integration.mqtt.outbound.Mqttv5PahoMessageHandler;
import org.springframework.messaging.MessageHandler;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={MqttProperties.class})
public class MqttConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MqttConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- SDK [Message Mqtt] Auto Configure.");
    }

    @Bean
    public ClientManager<IMqttAsyncClient, MqttConnectionOptions> clientManager(MqttProperties mqttProperties) {
        MqttConnectionOptions mqttConnectionOptions = new MqttConnectionOptions();
        mqttConnectionOptions.setUserName(mqttProperties.getUsername());
        mqttConnectionOptions.setPassword(ByteUtil.toBytes((CharSequence)mqttProperties.getPassword(), (Charset)StandardCharsets.UTF_8));
        mqttConnectionOptions.setCleanStart(mqttProperties.getCleanStart().booleanValue());
        mqttConnectionOptions.setKeepAliveInterval(this.toInt(mqttProperties.getKeepAliveInterval()));
        mqttConnectionOptions.setServerURIs(ListUtils.toStringArray(mqttProperties.getServerUrls()));
        mqttConnectionOptions.setAutomaticReconnect(mqttProperties.getAutomaticReconnect().booleanValue());
        mqttConnectionOptions.setAutomaticReconnectDelay(this.toInt(mqttProperties.getAutomaticReconnectMinDelay()), this.toInt(mqttProperties.getAutomaticReconnectMaxDelay()));
        log.info("[Herodotus] |- Bean [Mqtt Connection Options] Auto Configure.");
        Mqttv5ClientManager clientManager = new Mqttv5ClientManager(mqttConnectionOptions, mqttProperties.getClientId());
        clientManager.setPersistence((MqttClientPersistence)new MqttDefaultFilePersistence());
        return clientManager;
    }

    @Bean
    @ServiceActivator(inputChannel="mqtt5OutboundChannel")
    public IntegrationFlow mqtt5InFlowTopic2(ClientManager<IMqttAsyncClient, MqttConnectionOptions> clientManager) {
        Mqttv5PahoMessageDrivenChannelAdapter messageProducer = new Mqttv5PahoMessageDrivenChannelAdapter(clientManager, new String[]{"topic2"});
        return ((IntegrationFlowBuilder)IntegrationFlow.from((MessageProducerSupport)messageProducer).channel(c -> c.queue("fromMqttChannel"))).get();
    }

    @Bean
    public IntegrationFlow mqttOutFlow(ClientManager<IMqttAsyncClient, MqttConnectionOptions> clientManager) {
        return f -> f.handle((MessageHandler)new Mqttv5PahoMessageHandler(clientManager));
    }

    private int toInt(Duration duration) {
        long value = duration.getSeconds();
        return Long.valueOf(value).intValue();
    }
}

