/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.message.information.service;

import cn.herodotus.engine.data.core.repository.BaseRepository;
import cn.herodotus.engine.data.core.service.BaseLayeredService;
import cn.herodotus.engine.message.information.entity.MessagePullStamp;
import cn.herodotus.engine.message.information.entity.NotificationQueue;
import cn.herodotus.engine.message.information.entity.SystemAnnouncement;
import cn.herodotus.engine.message.information.repository.NotificationQueueRepository;
import cn.herodotus.engine.message.information.service.MessagePullStampService;
import cn.herodotus.engine.message.information.service.SystemAnnouncementService;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NotificationQueueService
extends BaseLayeredService<NotificationQueue, String> {
    private static final Logger log = LoggerFactory.getLogger(NotificationQueueService.class);
    private final NotificationQueueRepository notificationQueueRepository;
    private final MessagePullStampService messagePullStampService;
    private final SystemAnnouncementService systemAnnouncementService;

    public NotificationQueueService(NotificationQueueRepository notificationQueueRepository, MessagePullStampService messagePullStampService, SystemAnnouncementService systemAnnouncementService) {
        this.notificationQueueRepository = notificationQueueRepository;
        this.messagePullStampService = messagePullStampService;
        this.systemAnnouncementService = systemAnnouncementService;
    }

    public BaseRepository<NotificationQueue, String> getRepository() {
        return this.notificationQueueRepository;
    }

    public List<NotificationQueue> findAllUnReadNotifications(String userId) {
        List<NotificationQueue> notificationQueues = this.notificationQueueRepository.findAllByUserIdAndRead(userId, false);
        log.debug("[Herodotus] |- NotificationQueue Service findAllUnReadNotifications.");
        return notificationQueues;
    }

    private void pullAnnouncements(String userId) {
        MessagePullStamp messagePullStamp = this.messagePullStampService.getPullStamp(userId);
        List<SystemAnnouncement> systemAnnouncements = this.systemAnnouncementService.pullAnnouncements(messagePullStamp.getLatestPullTime());
        if (CollectionUtils.isNotEmpty(systemAnnouncements)) {
            List<NotificationQueue> notificationQueues = this.convertSystemAnnouncementsToNotificationQueues(userId, systemAnnouncements);
            this.saveAll(notificationQueues);
        }
    }

    @Transactional
    public List<NotificationQueue> findAllNotificationQueues(String userId) {
        this.pullAnnouncements(userId);
        List<NotificationQueue> unReadNotifications = this.findAllUnReadNotifications(userId);
        log.debug("[Herodotus] |- NotificationQueue Service findAllNotificationQueues.");
        return unReadNotifications;
    }

    private List<NotificationQueue> convertSystemAnnouncementsToNotificationQueues(String userId, List<SystemAnnouncement> systemAnnouncements) {
        return systemAnnouncements.stream().map(systemAnnouncement -> this.convertSystemAnnouncementToNotificationQueue(userId, (SystemAnnouncement)((Object)systemAnnouncement))).collect(Collectors.toList());
    }

    private NotificationQueue convertSystemAnnouncementToNotificationQueue(String userId, SystemAnnouncement systemAnnouncement) {
        NotificationQueue notificationQueue = new NotificationQueue();
        notificationQueue.setUserId(userId);
        notificationQueue.setContent(systemAnnouncement.getContent());
        notificationQueue.setSenderId(systemAnnouncement.getSenderId());
        notificationQueue.setSenderName(systemAnnouncement.getSenderName());
        notificationQueue.setCategory(1);
        return notificationQueue;
    }
}

