/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.message.core;

import cn.herodotus.engine.assistant.core.context.ServiceContextHolder;
import cn.herodotus.engine.message.core.definition.domain.StreamMessage;
import cn.herodotus.engine.message.core.definition.domain.TemplateMessage;
import cn.herodotus.engine.message.core.definition.domain.WebSocketMessage;
import cn.herodotus.engine.message.core.definition.event.AbstractApplicationEvent;
import cn.herodotus.engine.message.core.definition.event.StreamMessageSendingEvent;
import cn.herodotus.engine.message.core.definition.event.TemplateMessageSendingEvent;
import org.apache.commons.lang3.StringUtils;

class MessageSendingFacade {
    MessageSendingFacade() {
    }

    private static <T> void postProcess(AbstractApplicationEvent<T> event) {
        ServiceContextHolder.getInstance().publishEvent(event);
    }

    public static <T> void event(AbstractApplicationEvent<T> event) {
        MessageSendingFacade.postProcess(event);
    }

    public static <T extends TemplateMessage> void template(T message) {
        MessageSendingFacade.postProcess(new TemplateMessageSendingEvent<T>(message));
    }

    public static <T extends StreamMessage> void stream(T message) {
        MessageSendingFacade.postProcess(new StreamMessageSendingEvent<T>(message));
    }

    public static <T> void pointToPoint(String user, String destination, T payload) {
        WebSocketMessage message = new WebSocketMessage();
        if (StringUtils.isNotBlank((CharSequence)user)) {
            message.setUser(user);
        }
        message.setDestination(destination);
        message.setPayload(payload);
        MessageSendingFacade.template(message);
    }

    public static <T> void broadcast(String destination, T payload) {
        MessageSendingFacade.pointToPoint(null, destination, payload);
    }
}

