/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.message.core.definition.strategy;

import cn.herodotus.engine.assistant.core.context.ServiceContextHolder;
import cn.herodotus.engine.assistant.core.json.jackson2.utils.Jackson2Utils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationEvent;

public interface StrategyEventManager<T> {
    public void postLocalProcess(T var1);

    public void postRemoteProcess(String var1, String var2, String var3);

    default public boolean isLocal(String destinationService) {
        return !ServiceContextHolder.getInstance().isDistributedArchitecture() || StringUtils.equals((CharSequence)ServiceContextHolder.getInstance().getApplicationName(), (CharSequence)destinationService);
    }

    default public void postProcess(String destinationService, T data) {
        this.postProcess(ServiceContextHolder.getInstance().getOriginService(), destinationService, data);
    }

    default public void postProcess(String originService, String destinationService, T data) {
        if (this.isLocal(destinationService)) {
            this.postLocalProcess(data);
        } else {
            this.postRemoteProcess(Jackson2Utils.toJson(data), originService, destinationService);
        }
    }

    default public void publishEvent(ApplicationEvent event) {
        ServiceContextHolder.getInstance().publishEvent(event);
    }
}

