/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.logic.identity.service;

import cn.herodotus.engine.data.core.jpa.repository.BaseJpaRepository;
import cn.herodotus.engine.data.core.jpa.service.AbstractJpaService;
import cn.herodotus.engine.logic.identity.entity.OAuth2Permission;
import cn.herodotus.engine.logic.identity.entity.OAuth2Scope;
import cn.herodotus.engine.logic.identity.repository.OAuth2ScopeRepository;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.stereotype.Service;

@Service
public class OAuth2ScopeService
extends AbstractJpaService<OAuth2Scope, String> {
    private final OAuth2ScopeRepository oauthScopesRepository;

    public OAuth2ScopeService(OAuth2ScopeRepository oauthScopesRepository) {
        this.oauthScopesRepository = oauthScopesRepository;
    }

    public BaseJpaRepository<OAuth2Scope, String> getRepository() {
        return this.oauthScopesRepository;
    }

    public OAuth2Scope assigned(String scopeId, Set<OAuth2Permission> permissions) {
        Optional oldScope = this.findById((Serializable)((Object)scopeId));
        return oldScope.map(entity -> {
            entity.setPermissions(permissions);
            return entity;
        }).map(arg_0 -> ((OAuth2ScopeService)this).saveAndFlush(arg_0)).orElse(null);
    }

    public OAuth2Scope findByScopeCode(String scopeCode) {
        return this.oauthScopesRepository.findByScopeCode(scopeCode);
    }

    public List<OAuth2Scope> findByScopeCodeIn(List<String> scopeCodes) {
        return this.oauthScopesRepository.findByScopeCodeIn(scopeCodes);
    }
}

