/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.logic.identity.service;

import cn.herodotus.engine.core.definition.domain.BaseEntity;
import cn.herodotus.engine.core.foundation.exception.transaction.TransactionalRollbackException;
import cn.herodotus.engine.data.core.jpa.repository.BaseJpaRepository;
import cn.herodotus.engine.data.core.jpa.service.AbstractJpaService;
import cn.herodotus.engine.logic.identity.converter.OAuth2DeviceToRegisteredClientConverter;
import cn.herodotus.engine.logic.identity.converter.RegisteredClientToOAuth2DeviceConverter;
import cn.herodotus.engine.logic.identity.entity.OAuth2Device;
import cn.herodotus.engine.logic.identity.entity.OAuth2Scope;
import cn.herodotus.engine.logic.identity.repository.OAuth2DeviceRepository;
import cn.herodotus.engine.logic.identity.service.OAuth2ApplicationService;
import cn.herodotus.engine.logic.identity.service.OAuth2ScopeService;
import cn.herodotus.engine.oauth2.persistence.sas.jpa.repository.HerodotusRegisteredClientRepository;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.oidc.OidcClientRegistration;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OAuth2DeviceService
extends AbstractJpaService<OAuth2Device, String> {
    private static final Logger log = LoggerFactory.getLogger(OAuth2ApplicationService.class);
    private final RegisteredClientRepository registeredClientRepository;
    private final HerodotusRegisteredClientRepository herodotusRegisteredClientRepository;
    private final OAuth2DeviceRepository deviceRepository;
    private final Converter<OAuth2Device, RegisteredClient> oauth2DeviceToRegisteredClientConverter;
    private final Converter<RegisteredClient, OAuth2Device> registeredClientToOAuth2DeviceConverter;

    public OAuth2DeviceService(RegisteredClientRepository registeredClientRepository, HerodotusRegisteredClientRepository herodotusRegisteredClientRepository, OAuth2DeviceRepository deviceRepository, OAuth2ScopeService scopeService) {
        this.registeredClientRepository = registeredClientRepository;
        this.herodotusRegisteredClientRepository = herodotusRegisteredClientRepository;
        this.deviceRepository = deviceRepository;
        this.oauth2DeviceToRegisteredClientConverter = new OAuth2DeviceToRegisteredClientConverter();
        this.registeredClientToOAuth2DeviceConverter = new RegisteredClientToOAuth2DeviceConverter(scopeService);
    }

    public BaseJpaRepository<OAuth2Device, String> getRepository() {
        return this.deviceRepository;
    }

    @Transactional(rollbackFor={TransactionalRollbackException.class})
    public OAuth2Device saveAndFlush(OAuth2Device entity) {
        OAuth2Device device = (OAuth2Device)super.saveAndFlush((BaseEntity)entity);
        if (ObjectUtils.isNotEmpty((Object)((Object)device))) {
            this.registeredClientRepository.save((RegisteredClient)this.oauth2DeviceToRegisteredClientConverter.convert((Object)device));
            return device;
        }
        log.error("[Herodotus] |- OAuth2DeviceService saveOrUpdate error, rollback data!");
        throw new NullPointerException("save or update OAuth2DeviceService failed");
    }

    @Transactional(rollbackFor={TransactionalRollbackException.class})
    public void deleteById(String id) {
        super.deleteById((Serializable)((Object)id));
        this.herodotusRegisteredClientRepository.deleteById((Serializable)((Object)id));
    }

    @Transactional(rollbackFor={TransactionalRollbackException.class})
    public OAuth2Device authorize(String deviceId, String[] scopeIds) {
        HashSet<OAuth2Scope> scopes = new HashSet<OAuth2Scope>();
        for (String scopeId : scopeIds) {
            OAuth2Scope scope = new OAuth2Scope();
            scope.setScopeId(scopeId);
            scopes.add(scope);
        }
        Optional oldDevice = this.findById((Serializable)((Object)deviceId));
        return oldDevice.map(entity -> {
            entity.setScopes(scopes);
            return entity;
        }).map(this::saveAndFlush).orElse(null);
    }

    public boolean sync(OidcClientRegistration oidcClientRegistration) {
        OAuth2Device oauth2Device;
        RegisteredClient registeredClient = this.registeredClientRepository.findByClientId(oidcClientRegistration.getClientId());
        if (ObjectUtils.isNotEmpty((Object)registeredClient) && ObjectUtils.isNotEmpty((Object)((Object)(oauth2Device = (OAuth2Device)((Object)this.registeredClientToOAuth2DeviceConverter.convert((Object)registeredClient)))))) {
            OAuth2Device result = (OAuth2Device)((Object)this.deviceRepository.save((Object)oauth2Device));
            return ObjectUtils.isNotEmpty((Object)((Object)result));
        }
        return false;
    }

    public boolean activate(String clientId, boolean isActivated) {
        int result = this.deviceRepository.activate(clientId, isActivated);
        return result != 0;
    }
}

