/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.logic.identity.service;

import cn.herodotus.engine.core.definition.domain.BaseEntity;
import cn.herodotus.engine.core.foundation.exception.transaction.TransactionalRollbackException;
import cn.herodotus.engine.data.core.jpa.repository.BaseJpaRepository;
import cn.herodotus.engine.data.core.jpa.service.AbstractJpaService;
import cn.herodotus.engine.logic.identity.converter.OAuth2ApplicationToRegisteredClientConverter;
import cn.herodotus.engine.logic.identity.entity.OAuth2Application;
import cn.herodotus.engine.logic.identity.entity.OAuth2Scope;
import cn.herodotus.engine.logic.identity.repository.OAuth2ApplicationRepository;
import cn.herodotus.engine.oauth2.persistence.sas.jpa.repository.HerodotusRegisteredClientRepository;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OAuth2ApplicationService
extends AbstractJpaService<OAuth2Application, String> {
    private static final Logger log = LoggerFactory.getLogger(OAuth2ApplicationService.class);
    private final RegisteredClientRepository registeredClientRepository;
    private final HerodotusRegisteredClientRepository herodotusRegisteredClientRepository;
    private final OAuth2ApplicationRepository applicationRepository;
    private final Converter<OAuth2Application, RegisteredClient> objectConverter;

    public OAuth2ApplicationService(RegisteredClientRepository registeredClientRepository, HerodotusRegisteredClientRepository herodotusRegisteredClientRepository, OAuth2ApplicationRepository applicationRepository) {
        this.registeredClientRepository = registeredClientRepository;
        this.herodotusRegisteredClientRepository = herodotusRegisteredClientRepository;
        this.applicationRepository = applicationRepository;
        this.objectConverter = new OAuth2ApplicationToRegisteredClientConverter();
    }

    public BaseJpaRepository<OAuth2Application, String> getRepository() {
        return this.applicationRepository;
    }

    public OAuth2Application saveAndFlush(OAuth2Application entity) {
        OAuth2Application application = (OAuth2Application)super.saveAndFlush((BaseEntity)entity);
        if (ObjectUtils.isNotEmpty((Object)((Object)application))) {
            this.registeredClientRepository.save((RegisteredClient)this.objectConverter.convert((Object)application));
            log.debug("[Herodotus] |- OAuth2ApplicationService saveOrUpdate.");
            return application;
        }
        log.error("[Herodotus] |- OAuth2ApplicationService saveOrUpdate error, rollback data!");
        throw new NullPointerException("save or update OAuth2Application failed");
    }

    @Transactional(rollbackFor={TransactionalRollbackException.class})
    public void deleteById(String id) {
        super.deleteById((Serializable)((Object)id));
        this.herodotusRegisteredClientRepository.deleteById((Serializable)((Object)id));
    }

    @Transactional(rollbackFor={TransactionalRollbackException.class})
    public OAuth2Application authorize(String applicationId, String[] scopeIds) {
        HashSet<OAuth2Scope> scopes = new HashSet<OAuth2Scope>();
        for (String scopeId : scopeIds) {
            OAuth2Scope scope = new OAuth2Scope();
            scope.setScopeId(scopeId);
            scopes.add(scope);
        }
        Optional oldApplication = this.findById((Serializable)((Object)applicationId));
        return oldApplication.map(entity -> {
            entity.setScopes(scopes);
            return entity;
        }).map(this::saveAndFlush).orElse(null);
    }

    public OAuth2Application findByClientId(String clientId) {
        return this.applicationRepository.findByClientId(clientId);
    }
}

