/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.logic.identity.enums;

import cn.herodotus.engine.core.definition.enums.BaseUiEnum;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.google.common.collect.ImmutableMap;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;

@Schema(name="OAuth2 Client \u8ba4\u8bc1\u65b9\u5f0f")
@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public enum AuthenticationMethod implements BaseUiEnum<String>
{
    CLIENT_SECRET_BASIC(ClientAuthenticationMethod.CLIENT_SECRET_BASIC.getValue(), "\u57fa\u4e8eClient Secret\u7684Basic\u9a8c\u8bc1\u6a21\u5f0f"),
    CLIENT_SECRET_POST(ClientAuthenticationMethod.CLIENT_SECRET_POST.getValue(), "\u57fa\u4e8eClient Secret\u7684Post\u9a8c\u8bc1\u6a21\u5f0f"),
    CLIENT_SECRET_JWT(ClientAuthenticationMethod.CLIENT_SECRET_JWT.getValue(), "\u57fa\u4e8eClient Secret\u7684JWT\u9a8c\u8bc1\u6a21\u5f0f"),
    PRIVATE_KEY_JWT(ClientAuthenticationMethod.PRIVATE_KEY_JWT.getValue(), "\u57fa\u4e8e\u79c1\u94a5\u7684JWT\u9a8c\u8bc1\u6a21\u5f0f"),
    NONE(ClientAuthenticationMethod.NONE.getValue(), "\u4e0d\u8bbe\u7f6e\u4efb\u4f55\u6a21\u5f0f"),
    TLS_CLIENT_AUTH(ClientAuthenticationMethod.TLS_CLIENT_AUTH.getValue(), "TSL \u5ba2\u6237\u7aef\u8ba4\u8bc1"),
    SELF_SIGNED_TLS_CLIENT_AUTH(ClientAuthenticationMethod.SELF_SIGNED_TLS_CLIENT_AUTH.getValue(), "\u81ea\u7b7e\u540d TSL \u5ba2\u6237\u7aef\u8ba4\u8bc1");

    private static final Map<Integer, AuthenticationMethod> INDEX_MAP;
    private static final List<Map<String, Object>> JSON_STRUCTURE;
    @Schema(name="\u8ba4\u8bc1\u65b9\u6cd5")
    private final String value;
    @Schema(name="\u6587\u5b57")
    private final String description;

    private AuthenticationMethod(String value, String description) {
        this.value = value;
        this.description = description;
    }

    public static AuthenticationMethod get(Integer index) {
        return INDEX_MAP.get(index);
    }

    public static List<Map<String, Object>> getPreprocessedJsonStructure() {
        return JSON_STRUCTURE;
    }

    public String getDescription() {
        return this.description;
    }

    public String getValue() {
        return this.value;
    }

    static {
        INDEX_MAP = new HashMap<Integer, AuthenticationMethod>();
        JSON_STRUCTURE = new ArrayList<Map<String, Object>>();
        for (AuthenticationMethod authenticationMethod : AuthenticationMethod.values()) {
            INDEX_MAP.put(authenticationMethod.ordinal(), authenticationMethod);
            JSON_STRUCTURE.add(authenticationMethod.ordinal(), (Map<String, Object>)ImmutableMap.builder().put((Object)"value", (Object)authenticationMethod.getValue()).put((Object)"key", (Object)authenticationMethod.name()).put((Object)"text", (Object)authenticationMethod.getDescription()).put((Object)"index", (Object)authenticationMethod.ordinal()).build());
        }
    }
}

