/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.facility.kafka.autoconfigure;

import cn.herodotus.engine.facility.kafka.autoconfigure.annotation.ConditionalOnKafkaEnabled;
import cn.herodotus.engine.facility.kafka.autoconfigure.properties.KafkaProperties;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;

@AutoConfiguration
@ConditionalOnKafkaEnabled
@EnableConfigurationProperties(value={KafkaProperties.class})
public class FacilityKafkaAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(FacilityKafkaAutoConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.info("[Herodotus] |- Starter [Facility Kafka] Configure.");
    }

    @Bean
    @ConditionalOnMissingBean(value={ConcurrentKafkaListenerContainerFactory.class})
    public ConcurrentKafkaListenerContainerFactory<String, String> concurrentKafkaListenerContainerFactory(KafkaProperties kafkaProperties, ConsumerFactory<String, String> consumerFactory) {
        ConcurrentKafkaListenerContainerFactory concurrentKafkaListenerContainerFactory = new ConcurrentKafkaListenerContainerFactory();
        concurrentKafkaListenerContainerFactory.setConsumerFactory(consumerFactory);
        concurrentKafkaListenerContainerFactory.setAutoStartup(kafkaProperties.getEnabled());
        log.trace("[Herodotus] |- Bean [Concurrent Kafka Listener ContainerFactory] Configure.");
        return concurrentKafkaListenerContainerFactory;
    }
}

