/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.facility.core.configuration;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import cn.herodotus.engine.assistant.core.json.jackson2.utils.JacksonUtils;
import cn.herodotus.engine.facility.core.annotation.ConditionalOnLogEnabled;
import cn.herodotus.engine.facility.core.properties.LogProperties;
import com.google.common.base.MoreObjects;
import jakarta.annotation.PostConstruct;
import java.util.Map;
import net.logstash.logback.appender.LogstashTcpSocketAppender;
import net.logstash.logback.composite.JsonProvider;
import net.logstash.logback.encoder.LogstashEncoder;
import org.apache.skywalking.apm.toolkit.log.logback.v1.x.logstash.TraceIdJsonProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.logging.LogLevel;

@AutoConfiguration
@ConditionalOnLogEnabled
@EnableConfigurationProperties(value={LogProperties.class})
public class FacilityLogConfiguration {
    private static final Logger log = LoggerFactory.getLogger(FacilityLogConfiguration.class);
    @Value(value="${spring.application.name}")
    private String serviceName;
    @Autowired
    private LogProperties logProperties;

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- SDK [Facility Log] Auto Configure.");
    }

    @PostConstruct
    public void init() {
        ch.qos.logback.classic.Logger rootLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
        LoggerContext loggerContext = rootLogger.getLoggerContext();
        LogstashTcpSocketAppender logstashTcpSocketAppender = new LogstashTcpSocketAppender();
        logstashTcpSocketAppender.setName("LOGSTASH");
        logstashTcpSocketAppender.addDestination(this.logProperties.getServerAddr());
        logstashTcpSocketAppender.setKeepAliveDuration(this.logProperties.getKeepAliveDuration());
        logstashTcpSocketAppender.setReconnectionDelay(this.logProperties.getReconnectionDelay());
        logstashTcpSocketAppender.setWriteTimeout(this.logProperties.getWriteTimeout());
        logstashTcpSocketAppender.setContext((Context)loggerContext);
        TraceIdJsonProvider traceIdJsonProvider = new TraceIdJsonProvider();
        traceIdJsonProvider.setContext((Context)loggerContext);
        CustomFields customFields = new CustomFields();
        customFields.setService(this.serviceName);
        LogstashEncoder logstashEncoder = new LogstashEncoder();
        logstashEncoder.setCustomFields(JacksonUtils.toJson((Object)customFields));
        logstashEncoder.addProvider((JsonProvider)traceIdJsonProvider);
        logstashTcpSocketAppender.setEncoder((Encoder)logstashEncoder);
        logstashTcpSocketAppender.start();
        rootLogger.addAppender((Appender)logstashTcpSocketAppender);
        rootLogger.setLevel(Level.toLevel((String)this.logProperties.getLogLevel().name(), (Level)Level.INFO));
        Map<String, LogLevel> loggers = this.logProperties.getLoggers();
        loggers.forEach((key, value) -> {
            ch.qos.logback.classic.Logger logger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)key);
            logger.setLevel(Level.toLevel((String)value.name()));
        });
    }

    private static class CustomFields {
        private String service;

        private CustomFields() {
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("service", (Object)this.service).toString();
        }
    }
}

