/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.facility.alibaba.sentinel.enhance;

import cn.herodotus.engine.assistant.core.domain.Result;
import cn.herodotus.engine.assistant.core.exception.GlobalExceptionHandler;
import com.google.common.base.Objects;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;

public class HerodotusFeignFallback<T>
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(HerodotusFeignFallback.class);
    private final Class<T> targetType;
    private final String targetName;
    private final Throwable cause;

    public HerodotusFeignFallback(Class<T> targetType, String targetName, Throwable cause) {
        this.targetType = targetType;
        this.targetName = targetName;
        this.cause = cause;
    }

    public Object intercept(Object o, Method method, Object[] objects, MethodProxy methodProxy) throws Throwable {
        String errorMessage = this.cause.getMessage();
        String path = this.targetType.getName() + "/" + method.getName();
        Result result = GlobalExceptionHandler.resolveException((Exception)((Exception)this.cause), (String)path);
        log.error("[Herodotus] |- Feign remote call fallback : [{}.{}] serviceId:[{}] message:[{}]", new Object[]{this.targetType.getName(), method.getName(), this.targetName, errorMessage});
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HerodotusFeignFallback that = (HerodotusFeignFallback)o;
        return Objects.equal(this.targetType, that.targetType);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.targetType});
    }
}

