/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.facility.alibaba.sentinel.configuration;

import cn.herodotus.engine.assistant.core.domain.Result;
import cn.herodotus.engine.assistant.core.json.jackson2.utils.JacksonUtils;
import com.alibaba.cloud.sentinel.feign.SentinelFeignAutoConfiguration;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.adapter.spring.webflux.callback.BlockRequestHandler;
import com.alibaba.csp.sentinel.adapter.spring.webmvc.callback.BlockExceptionHandler;
import feign.Feign;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.ServerResponse;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={SphU.class, Feign.class})
@AutoConfigureBefore(value={SentinelFeignAutoConfiguration.class})
public class FacilityAlibabaSentinelConfiguration {
    private static final Logger log = LoggerFactory.getLogger(FacilityAlibabaSentinelConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- SDK [Facility Alibaba Sentinel] Auto Configure.");
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ServerResponse.class})
    public static class WebfluxHandler {
        @Bean
        public BlockRequestHandler webfluxBlockExceptionHandler() {
            return (exchange, t) -> ServerResponse.status((HttpStatusCode)HttpStatus.TOO_MANY_REQUESTS).contentType(MediaType.APPLICATION_JSON).body(BodyInserters.fromValue((Object)Result.failure((String)t.getMessage())));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HttpServletRequest.class})
    public static class WebmvcHandler {
        @Bean
        public BlockExceptionHandler webmvcBlockExceptionHandler() {
            return (request, response, e) -> {
                response.setStatus(HttpStatus.TOO_MANY_REQUESTS.value());
                Result result = Result.failure((String)"Too many request, please retry later.");
                response.getWriter().print(JacksonUtils.toJson((Object)result));
            };
        }
    }
}

