/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.core.identity.utils;

import cn.herodotus.engine.core.definition.utils.WellFormedUtils;
import cn.herodotus.engine.core.identity.domain.UserPrincipal;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.springframework.security.core.Authentication;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.PasswordEncoder;

public class SecurityUtils {
    public static final String PREFIX_ROLE = "ROLE_";
    private static final PasswordEncoder passwordEncoder = PasswordEncoderFactories.createDelegatingPasswordEncoder();

    public static boolean matches(String rawPassword, String encodedPassword) {
        return passwordEncoder.matches((CharSequence)rawPassword, encodedPassword);
    }

    public static boolean isEncrypted(String password) {
        return Strings.CS.containsAny((CharSequence)password, new CharSequence[]{"{", "}"});
    }

    public static String encrypt(String password) {
        return SecurityUtils.encrypt(password, passwordEncoder);
    }

    public static String encrypt(String password, PasswordEncoder passwordEncoder) {
        if (StringUtils.isNotBlank((CharSequence)password)) {
            if (SecurityUtils.isEncrypted(password)) {
                return password;
            }
            return passwordEncoder.encode((CharSequence)password);
        }
        return null;
    }

    public static String wellFormRolePrefix(String content) {
        return WellFormedUtils.robustness((String)content, (String)PREFIX_ROLE, (boolean)true, (boolean)true);
    }

    public static UserPrincipal getUserPrincipal(Authentication authentication) {
        Object details = authentication.getDetails();
        if (ObjectUtils.isNotEmpty((Object)details) && details instanceof UserPrincipal) {
            UserPrincipal userPrincipal = (UserPrincipal)details;
            return userPrincipal;
        }
        return null;
    }

    public static Optional<UserPrincipal> findUserPrincipal(Authentication authentication) {
        return Optional.ofNullable(SecurityUtils.getUserPrincipal(authentication));
    }

    public static Optional<String> findUsername(Authentication authentication) {
        return SecurityUtils.findUserPrincipal(authentication).map(UserPrincipal::getName);
    }

    public static String getUsername(Authentication authentication) {
        return SecurityUtils.findUsername(authentication).orElse(null);
    }

    public static Optional<String> findUserId(Authentication authentication) {
        return SecurityUtils.findUserPrincipal(authentication).map(UserPrincipal::getId);
    }

    public static String getUserId(Authentication authentication) {
        return SecurityUtils.findUserId(authentication).orElse(null);
    }

    public static Optional<String> findEmail(Authentication authentication) {
        return SecurityUtils.findUserPrincipal(authentication).map(UserPrincipal::getEmail);
    }

    public static String getEmail(Authentication authentication) {
        return SecurityUtils.findEmail(authentication).orElse(null);
    }
}

