/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.core.identity.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class HerodotusSecurityAttribute
implements Serializable {
    private String attribute;

    public HerodotusSecurityAttribute() {
    }

    public HerodotusSecurityAttribute(String config) {
        Assert.hasText((String)config, (String)"You must provide a configuration attribute");
        this.attribute = config;
    }

    public static HerodotusSecurityAttribute create(String attribute) {
        Assert.notNull((Object)attribute, (String)"You must supply an array of attribute names");
        return new HerodotusSecurityAttribute(attribute.trim());
    }

    public static List<HerodotusSecurityAttribute> createListFromCommaDelimitedString(String access) {
        return HerodotusSecurityAttribute.createList(StringUtils.commaDelimitedListToStringArray((String)access));
    }

    public static List<HerodotusSecurityAttribute> createList(String ... attributeNames) {
        Assert.notNull((Object)attributeNames, (String)"You must supply an array of attribute names");
        ArrayList<HerodotusSecurityAttribute> attributes = new ArrayList<HerodotusSecurityAttribute>(attributeNames.length);
        for (String attribute : attributeNames) {
            attributes.add(new HerodotusSecurityAttribute(attribute.trim()));
        }
        return attributes;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HerodotusSecurityAttribute that = (HerodotusSecurityAttribute)o;
        return Objects.equal((Object)this.attribute, (Object)that.attribute);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.attribute});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("attrib", (Object)this.attribute).toString();
    }
}

