/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.cache.redis.utils;

import com.google.common.hash.Funnels;
import com.google.common.hash.Hashing;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RedisBitMapUtils {
    private static StringRedisTemplate stringRedisTemplate;

    @Autowired
    @Qualifier(value="stringRedisTemplate")
    public void setStringRedisTemplate(StringRedisTemplate stringRedisTemplate) {
        RedisBitMapUtils.stringRedisTemplate = stringRedisTemplate;
    }

    private static long hash(String key) {
        return Math.abs(Hashing.murmur3_128().hashObject((Object)key, Funnels.stringFunnel((Charset)StandardCharsets.UTF_8)).asInt());
    }

    public static Boolean setBit(String key, String param, boolean value) {
        return stringRedisTemplate.opsForValue().setBit((Object)key, RedisBitMapUtils.hash(param), value);
    }

    public static boolean getBit(String key, String param) {
        return Boolean.TRUE.equals(stringRedisTemplate.opsForValue().getBit((Object)key, RedisBitMapUtils.hash(param)));
    }

    public static Boolean setBit(String key, Long offset, boolean value) {
        return stringRedisTemplate.opsForValue().setBit((Object)key, offset.longValue(), value);
    }

    public static Boolean getBit(String key, long offset) {
        return stringRedisTemplate.opsForValue().getBit((Object)key, offset);
    }

    public static Long bitCount(String key) {
        return (Long)stringRedisTemplate.execute(connection -> connection.stringCommands().bitCount(key.getBytes(StandardCharsets.UTF_8)));
    }

    public static Long bitCount(String key, int start, int end) {
        return (Long)stringRedisTemplate.execute(connection -> connection.stringCommands().bitCount(key.getBytes(), (long)start, (long)end));
    }

    public static Long bitOp(RedisStringCommands.BitOperation op, String saveKey, String ... destKey) {
        byte[][] bytes = new byte[destKey.length][];
        for (int i = 0; i < destKey.length; ++i) {
            bytes[i] = destKey[i].getBytes();
        }
        return (Long)stringRedisTemplate.execute(connection -> connection.stringCommands().bitOp(op, saveKey.getBytes(), bytes));
    }

    public static Long bitOpResult(RedisStringCommands.BitOperation op, String saveKey, String ... destKey) {
        RedisBitMapUtils.bitOp(op, saveKey, destKey);
        return RedisBitMapUtils.bitCount(saveKey);
    }
}

