/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.cache.redis.definition;

import cn.herodotus.engine.cache.redis.definition.StringRedisCache;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.StringRedisTemplate;

public abstract class AbstractStringRedisCache
implements StringRedisCache {
    private static final Duration DEFAULT_TIMEOUT = Duration.ofMinutes(10L);
    private static final String DEFAULT_PREFIX = "cache:simple:default:";
    private StringRedisTemplate stringRedisTemplate;
    private String prefix = "cache:simple:default:";
    private long defaultTimeout = DEFAULT_TIMEOUT.toMillis();

    public void setStringRedisTemplate(StringRedisTemplate stringRedisTemplate) {
        this.stringRedisTemplate = stringRedisTemplate;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setDefaultTimeout(long defaultTimeout) {
        this.defaultTimeout = defaultTimeout;
    }

    @Override
    public void cache(String key, String value) {
        this.cache(key, value, this.defaultTimeout);
    }

    @Override
    public void cache(String key, String value, long timeout) {
        this.stringRedisTemplate.opsForValue().set((Object)(this.prefix + key), (Object)value, timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public String get(String key) {
        return (String)this.stringRedisTemplate.opsForValue().get((Object)(this.prefix + key));
    }

    @Override
    public boolean containsKey(String key) {
        Long expire = this.stringRedisTemplate.getExpire((Object)(this.prefix + key), TimeUnit.MILLISECONDS);
        if (expire == null) {
            expire = 0L;
        }
        return expire > 0L;
    }

    @Override
    public boolean delete(String key) {
        if (this.containsKey(key)) {
            return this.stringRedisTemplate.delete((Object)key);
        }
        return true;
    }
}

