/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.cache.redis.configuration;

import cn.herodotus.engine.cache.redis.annotation.ConditionalOnRedisSessionSharing;
import cn.herodotus.engine.cache.redis.configuration.CacheRedisConfiguration;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.session.FlushMode;
import org.springframework.session.data.redis.config.annotation.web.http.EnableRedisIndexedHttpSession;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.DefaultCookieSerializer;

@Configuration(proxyBeanMethods=false)
@ConditionalOnRedisSessionSharing
public class RedisSessionSharingConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CacheRedisConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- SDK [Cache Redis Session Sharing] Auto Configure.");
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @EnableRedisIndexedHttpSession(flushMode=FlushMode.IMMEDIATE)
    static class HerodotusRedisHttpSessionConfiguration {
        HerodotusRedisHttpSessionConfiguration() {
        }

        @Bean
        public CookieSerializer cookieSerializer() {
            DefaultCookieSerializer cookieSerializer = new DefaultCookieSerializer();
            cookieSerializer.setUseHttpOnlyCookie(false);
            cookieSerializer.setSameSite(null);
            log.trace("[Herodotus] |- Bean [Cookie Serializer] Auto Configure.");
            return cookieSerializer;
        }
    }
}

