/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.cache.redis.session;

import cn.hutool.core.codec.Base64;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpCookie;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.session.CookieWebSessionIdResolver;

public class HerodotusCookieWebSessionIdResolver
extends CookieWebSessionIdResolver {
    private static final Logger log = LoggerFactory.getLogger(HerodotusCookieWebSessionIdResolver.class);

    public List<String> resolveSessionIds(ServerWebExchange exchange) {
        MultiValueMap cookieMap = exchange.getRequest().getCookies();
        List cookies = (List)cookieMap.get((Object)this.getCookieName());
        if (cookies == null) {
            return Collections.emptyList();
        }
        return cookies.stream().map(HttpCookie::getValue).map(this::base64Decode).collect(Collectors.toList());
    }

    private String base64Decode(String base64Value) {
        String result = Base64.decodeStr((CharSequence)base64Value);
        log.debug("[Herodotus] |- Webflux decode session id to: [{}]" + result);
        return result;
    }
}

