/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.cache.redis.configuration;

import cn.herodotus.engine.cache.redis.annotation.ConditionalOnRedisSessionSharing;
import cn.herodotus.engine.cache.redis.configuration.RedisConfiguration;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Configuration;
import org.springframework.session.FlushMode;
import org.springframework.session.data.redis.config.annotation.web.http.EnableRedisHttpSession;

@Configuration(proxyBeanMethods=false)
@ConditionalOnRedisSessionSharing
public class RedisSessionConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RedisConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- SDK [Engine Cache Redis Session] Auto Configure.");
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HttpServletRequest.class})
    @EnableRedisHttpSession(flushMode=FlushMode.IMMEDIATE)
    public static class HttpSessionConfiguration {
        @PostConstruct
        public void postConstruct() {
            log.debug("[Herodotus] |- SDK [Engine Cache Redis Http Session] Auto Configure.");
        }
    }
}

