/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.cache.redis.configuration;

import cn.herodotus.engine.cache.redis.annotation.ConditionalOnRedisSessionSharing;
import cn.herodotus.engine.cache.redis.configuration.RedisConfiguration;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.session.FlushMode;
import org.springframework.session.data.redis.config.annotation.web.http.EnableRedisHttpSession;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnRedisSessionSharing
@EnableRedisHttpSession(flushMode=FlushMode.IMMEDIATE)
public class RedisSessionSharingConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RedisConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- SDK [Engine Cache Redis Session Sharing] Auto Configure.");
    }

    @Bean
    @ConditionalOnMissingBean
    public HttpSessionListener httpSessionListener() {
        HttpSessionListener httpSessionListener = new HttpSessionListener(){

            public void sessionCreated(HttpSessionEvent httpSessionEvent) {
                HttpSession httpSession = httpSessionEvent.getSession();
                log.info("[Herodotus] |- Session is CREATED, is [{}].", (Object)(ObjectUtils.isNotEmpty((Object)httpSession) ? httpSession.getId() : ""));
            }

            public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
                HttpSession httpSession = httpSessionEvent.getSession();
                log.info("[Herodotus] |- Session is DESTROYED, is [{}].", (Object)httpSession.getId());
            }
        };
        log.trace("[Herodotus] |- Bean [Http Session Listener] Auto Configure.");
        return httpSessionListener;
    }
}

