/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.cache.redis.configuration;

import cn.herodotus.engine.cache.redis.annotation.ConditionalOnRedisSessionSharing;
import cn.herodotus.engine.cache.redis.configuration.RedisConfiguration;
import cn.herodotus.engine.cache.redis.session.HerodotusCookieWebSessionIdResolver;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.session.FlushMode;
import org.springframework.session.SaveMode;
import org.springframework.session.data.redis.config.annotation.web.http.EnableRedisHttpSession;
import org.springframework.session.data.redis.config.annotation.web.server.EnableRedisWebSession;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.server.session.WebSessionIdResolver;

@Configuration(proxyBeanMethods=false)
@ConditionalOnRedisSessionSharing
public class RedisSessionConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RedisConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- SDK [Engine Cache Redis Session] Auto Configure.");
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ServerResponse.class})
    @EnableRedisWebSession(saveMode=SaveMode.ALWAYS)
    public static class RedisWebSessionConfiguration {
        @PostConstruct
        public void postConstruct() {
            log.debug("[Herodotus] |- SDK [Engine Cache Redis Web Session] Auto Configure.");
        }

        @Bean
        public WebSessionIdResolver webSessionIdResolver() {
            return new HerodotusCookieWebSessionIdResolver();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HttpServletRequest.class})
    @EnableRedisHttpSession(flushMode=FlushMode.IMMEDIATE)
    public static class RedisHttpSessionConfiguration {
        @PostConstruct
        public void postConstruct() {
            log.debug("[Herodotus] |- SDK [Engine Cache Redis Http Session] Auto Configure.");
        }
    }
}

